/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.blocks.itemfilter.ItemFilterInvWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemFilterTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_SETMODE = "itemfilter.setMode";
    public static final Key<Integer> PARAM_SIDE = new Key("side", Type.INTEGER);
    public static final Key<Integer> PARAM_SLOT = new Key("slot", Type.INTEGER);
    public static final Key<Boolean> PARAM_INPUT = new Key("input", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_OUTPUT = new Key("output", Type.BOOLEAN);
    public static final int SLOT_GHOST = 0;
    public static final int BUFFER_SIZE = 9;
    public static final int GHOST_SIZE = 9;
    public static final int SLOT_PLAYERINV = 18;
    public static final int SLOT_BUFFER = 9;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), "container", 0, 24, 105, 9, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), "container", 9, 24, 87, 9, 18, 1, 18);
            this.layoutPlayerInventorySlots(24, 130);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 18);
    private int[] inputMode = new int[6];
    private int[] outputMode = new int[6];
    private IItemHandler invHandlerN = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    private IItemHandler invHandlerS = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
    private IItemHandler invHandlerW = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private IItemHandler invHandlerE = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    private IItemHandler invHandlerD = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler invHandlerU = new ItemFilterInvWrapper((ISidedInventory)this, EnumFacing.UP);

    public int[] getInputMode() {
        return this.inputMode;
    }

    public int[] getOutputMode() {
        return this.outputMode;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.inputMode = tagCompound.getIntArray("inputs");
        this.outputMode = tagCompound.getIntArray("outputs");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setIntArray("inputs", this.inputMode);
        tagCompound.setIntArray("outputs", this.outputMode);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            Integer side = (Integer)params.get(PARAM_SIDE);
            Integer slot = (Integer)params.get(PARAM_SLOT);
            Boolean input = (Boolean)params.get(PARAM_INPUT);
            Boolean output = (Boolean)params.get(PARAM_OUTPUT);
            int n = side;
            this.inputMode[n] = this.inputMode[n] & ~(1 << slot);
            if (input.booleanValue()) {
                int n2 = side;
                this.inputMode[n2] = this.inputMode[n2] | 1 << slot;
            }
            int n3 = side;
            this.outputMode[n3] = this.outputMode[n3] & ~(1 << slot);
            if (output.booleanValue()) {
                int n4 = side;
                this.outputMode[n4] = this.outputMode[n4] | 1 << slot;
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index < 9) {
            return false;
        }
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(index - 9);
        return ghostStack.isEmpty() || ghostStack.isItemEqual(stack);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        int v = 9;
        return new int[]{v, v + 1, v + 2, v + 3, v + 4, v + 5, v + 6, v + 7, v + 8};
    }

    public boolean canInsertItem(int index, ItemStack stack, EnumFacing side) {
        if (index < 9) {
            return false;
        }
        if (!this.isInputMode(side, index - 9)) {
            return false;
        }
        int ghostIndex = index - 9;
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(ghostIndex);
        if (ghostStack.isEmpty()) {
            int im = this.inputMode[side.ordinal()];
            for (int i = 0; i < 9; ++i) {
                ItemStack g = this.inventoryHelper.getStackInSlot(i);
                if (g.isEmpty() || (im & 1 << i) == 0 || !g.isItemEqual(stack)) continue;
                return false;
            }
            return true;
        }
        return ghostStack.isItemEqual(stack);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        if (index < 9) {
            return false;
        }
        return this.isOutputMode(direction, index - 9);
    }

    private boolean isInputMode(EnumFacing side, int slot) {
        return (this.inputMode[side.ordinal()] & 1 << slot) != 0;
    }

    private boolean isOutputMode(EnumFacing side, int slot) {
        return (this.outputMode[side.ordinal()] & 1 << slot) != 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return (T)this.invHandlerD;
                }
                case UP: {
                    return (T)this.invHandlerU;
                }
                case NORTH: {
                    return (T)this.invHandlerN;
                }
                case SOUTH: {
                    return (T)this.invHandlerS;
                }
                case WEST: {
                    return (T)this.invHandlerW;
                }
                case EAST: {
                    return (T)this.invHandlerE;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

