/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.digit;

import mcjty.lib.tileentity.LogicTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DigitTileEntity
extends LogicTileEntity {
    public static PropertyInteger VALUE = PropertyInteger.create((String)"value", (int)0, (int)15);

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int p = this.getPowerLevel();
        super.onDataPacket(net, packet);
        if (p != this.getPowerLevel()) {
            this.world.markBlockRangeForRenderUpdate(this.pos, this.pos);
        }
    }

    public IBlockState getActualState(IBlockState state) {
        return super.getActualState(state).withProperty((IProperty)VALUE, (Comparable)Integer.valueOf(this.getPowerLevel()));
    }

    public void checkRedstone(World world, BlockPos pos) {
        EnumFacing inputSide = this.getFacing(world.getBlockState(pos)).getInputSide();
        int power = this.getInputStrength(world, pos, inputSide);
        int oldPower = this.getPowerLevel();
        this.setPowerInput(power);
        if (oldPower != power) {
            this.markDirtyClient();
        }
    }
}

