/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.timer;

import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.TickOrderHandler;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class TimerTileEntity
extends LogicTileEntity
implements ITickable,
TickOrderHandler.ICheckStateServer {
    public static final String CMD_SETDELAY = "timer.setDelay";
    public static final String CMD_SETPAUSES = "timer.setPauses";
    private boolean prevIn = false;
    private int delay = 20;
    private int timer = 0;
    private boolean redstonePauses = false;

    public int getDelay() {
        return this.delay;
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean getRedstonePauses() {
        return this.redstonePauses;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.markDirtyClient();
    }

    public void setRedstonePauses(boolean redstonePauses) {
        this.redstonePauses = redstonePauses;
        if (redstonePauses && this.powerLevel > 0) {
            this.timer = this.delay;
        }
        this.markDirtyClient();
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            TickOrderHandler.queueTimer(this);
        }
    }

    @Override
    public void checkStateServer() {
        int newout;
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        this.markDirty();
        if (pulse) {
            this.timer = this.delay;
        }
        if (!this.redstonePauses || !this.prevIn) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = this.delay;
            newout = 15;
        } else {
            newout = 0;
        }
        this.setRedstoneState(newout);
    }

    @Override
    public int getDimension() {
        return this.world.provider.getDimension();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.powerOutput = tagCompound.getBoolean("rs") ? 15 : 0;
        this.prevIn = tagCompound.getBoolean("prevIn");
        this.timer = tagCompound.getInteger("timer");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.delay = tagCompound.getInteger("delay");
        this.redstonePauses = tagCompound.getBoolean("redstonePauses");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setBoolean("rs", this.powerOutput > 0);
        tagCompound.setBoolean("prevIn", this.prevIn);
        tagCompound.setInteger("timer", this.timer);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.setInteger("delay", this.delay);
        tagCompound.setBoolean("redstonePauses", this.redstonePauses);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            int delay;
            String text = (String)params.get(TextField.PARAM_TEXT);
            try {
                delay = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                delay = 1;
            }
            this.setDelay(delay);
            return true;
        }
        if (CMD_SETPAUSES.equals(command)) {
            Boolean on = (Boolean)params.get(ToggleButton.PARAM_ON);
            this.setRedstonePauses(on);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.GREEN + "Time: " + TextFormatting.WHITE + this.getTimer());
    }
}

