/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.powercell;

import java.text.DecimalFormat;
import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.powercell.GuiPowerCell;
import mcjty.rftools.blocks.powercell.PowerCellConfiguration;
import mcjty.rftools.blocks.powercell.PowerCellContainer;
import mcjty.rftools.blocks.powercell.PowerCellNetwork;
import mcjty.rftools.blocks.powercell.PowerCellSetup;
import mcjty.rftools.blocks.powercell.PowerCellTileEntity;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.setup.GuiProxy;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class PowerCellBlock
extends GenericRFToolsBlock<PowerCellTileEntity, PowerCellContainer>
implements Infusable,
INBTPreservingIngredient {
    public static final PropertyEnum<PowerCellTileEntity.Mode> NORTH = PropertyEnum.create((String)"north", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> SOUTH = PropertyEnum.create((String)"south", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> WEST = PropertyEnum.create((String)"west", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> EAST = PropertyEnum.create((String)"east", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> UP = PropertyEnum.create((String)"up", PowerCellTileEntity.Mode.class);
    public static final PropertyEnum<PowerCellTileEntity.Mode> DOWN = PropertyEnum.create((String)"down", PowerCellTileEntity.Mode.class);
    private static long lastTime = 0L;

    public PowerCellBlock(String name, Class<? extends PowerCellTileEntity> clazz) {
        super(Material.IRON, clazz, PowerCellContainer::new, name, true);
    }

    public void initModel() {
        ResourceLocation blockRegistryName = this.getRegistryName();
        ResourceLocation itemRegistryName = new ResourceLocation(blockRegistryName.getNamespace(), blockRegistryName.getPath() + "_item");
        McJtyLib.proxy.initCustomItemModel(Item.getItemFromBlock((Block)this), 0, new ModelResourceLocation(itemRegistryName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<PowerCellTileEntity, PowerCellContainer, GenericGuiContainer<? super PowerCellTileEntity>> getGuiFactory() {
        return GuiPowerCell::new;
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public int getGuiID() {
        return GuiProxy.GUI_POWERCELL;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Energy: " + tagCompound.getInteger("energy"));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int totpower = PowerCellConfiguration.rfPerNormalCell.get() * this.getPowerFactor() / PowerCellConfiguration.simpleFactor.get();
            list.add(TextFormatting.WHITE + "This block can store power (" + totpower + " RF)");
            list.add(TextFormatting.WHITE + "Optionally in a big multi dimensional structure");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced long distance power");
            list.add(TextFormatting.YELLOW + "extraction cost and increased RF/tick output");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.getItem() == PowerCellSetup.powerCellCardItem;
            }
        };
    }

    private boolean isAdvanced() {
        return PowerCellBlock.isAdvanced((Block)this);
    }

    private boolean isSimple() {
        return PowerCellBlock.isSimple((Block)this);
    }

    public static boolean isAdvanced(Block block) {
        return block == PowerCellSetup.advancedPowerCellBlock || block == PowerCellSetup.creativePowerCellBlock;
    }

    public static boolean isSimple(Block block) {
        return block == PowerCellSetup.simplePowerCellBlock;
    }

    public static boolean isCreative(Block block) {
        return block == PowerCellSetup.creativePowerCellBlock;
    }

    private int getPowerFactor() {
        if (this.isSimple()) {
            return 1;
        }
        return this.isAdvanced() ? PowerCellConfiguration.advancedFactor.get() * PowerCellConfiguration.simpleFactor.get() : PowerCellConfiguration.simpleFactor.get();
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.getTileEntity(data.getPos());
        if (te instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            int id = powerCellTileEntity.getNetworkId();
            if (mode == ProbeMode.EXTENDED) {
                if (id != -1) {
                    probeInfo.text(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(id));
                } else {
                    probeInfo.text(TextFormatting.GREEN + "Local storage!");
                }
            }
            float costFactor = powerCellTileEntity.getCostFactor();
            int rfPerTick = powerCellTileEntity.getRfPerTickPerSide();
            probeInfo.text(TextFormatting.GREEN + "Input/Output: " + rfPerTick + " RF/t");
            PowerCellTileEntity.Mode powermode = powerCellTileEntity.getMode(data.getSideHit());
            if (powermode == PowerCellTileEntity.Mode.MODE_INPUT) {
                probeInfo.text(TextFormatting.YELLOW + "Side: input");
            } else if (powermode == PowerCellTileEntity.Mode.MODE_OUTPUT) {
                int cost = (int)((costFactor - 1.0f) * 1000.0f);
                probeInfo.text(TextFormatting.YELLOW + "Side: output (cost " + cost / 10 + "." + cost % 10 + "%)");
            }
            if (mode == ProbeMode.EXTENDED) {
                int rfPerTickIn = powerCellTileEntity.getLastRfPerTickIn();
                int rfPerTickOut = powerCellTileEntity.getLastRfPerTickOut();
                probeInfo.text(TextFormatting.GREEN + "In:  " + rfPerTickIn + "RF/t");
                probeInfo.text(TextFormatting.GREEN + "Out: " + rfPerTickOut + "RF/t");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)tileEntity;
            int id = powercell.getNetworkId();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (id != -1) {
                    currenttip.add(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(id));
                } else {
                    currenttip.add(TextFormatting.GREEN + "Local storage!");
                }
            }
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                powercell.requestDataFromServer("rftools", "getInfo", TypedMap.EMPTY);
            }
            long total = ((long)(PowerCellTileEntity.tooltipBlocks - PowerCellTileEntity.tooltipAdvancedBlocks) - (long)PowerCellTileEntity.tooltipSimpleBlocks) * (long)PowerCellConfiguration.rfPerNormalCell.get();
            total += (long)PowerCellTileEntity.tooltipAdvancedBlocks * (long)PowerCellConfiguration.rfPerNormalCell.get() * (long)PowerCellConfiguration.advancedFactor.get();
            if ((total += (long)PowerCellTileEntity.tooltipSimpleBlocks * (long)PowerCellConfiguration.rfPerNormalCell.get() / (long)PowerCellConfiguration.simpleFactor.get()) > Integer.MAX_VALUE) {
                total = Integer.MAX_VALUE;
            }
            currenttip.add(TextFormatting.GREEN + "Energy: " + PowerCellTileEntity.tooltipEnergy + "/" + total + " RF (" + PowerCellTileEntity.tooltipRfPerTick + " RF/t)");
            PowerCellTileEntity.Mode mode = powercell.getMode(accessor.getSide());
            if (mode == PowerCellTileEntity.Mode.MODE_INPUT) {
                currenttip.add(TextFormatting.YELLOW + "Side: input");
            } else if (mode == PowerCellTileEntity.Mode.MODE_OUTPUT) {
                int cost = (int)((PowerCellTileEntity.tooltipCostFactor - 1.0f) * 1000.0f);
                currenttip.add(TextFormatting.YELLOW + "Side: output (cost " + cost / 10 + "." + cost % 10 + "%)");
            }
        }
        return currenttip;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        SmartWrenchMode currentMode;
        if (!world.isRemote && (currentMode = SmartWrenchItem.getCurrentMode(player.getHeldItem(EnumHand.MAIN_HAND))) == SmartWrenchMode.MODE_SELECT && (te = world.getTileEntity(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            PowerCellTileEntity.dumpNetwork(player, powerCellTileEntity);
        }
        return true;
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powerCellTileEntity = (PowerCellTileEntity)te;
            powerCellTileEntity.toggleMode(side);
        }
        return true;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        PowerCellTileEntity powerCellTileEntity;
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (stack.hasTagCompound() && !world.isRemote) {
            int networkId;
            PowerCellTileEntity powerCellTileEntity2 = (PowerCellTileEntity)world.getTileEntity(pos);
            if (powerCellTileEntity2 != null && (networkId = powerCellTileEntity2.getNetworkId()) != -1) {
                int energy = stack.getTagCompound().getInteger("energy");
                PowerCellNetwork powerCellNetwork = PowerCellNetwork.getChannels(world);
                PowerCellNetwork.Network network = powerCellNetwork.getChannel(networkId);
                network.receiveEnergy(energy);
                Block block = world.getBlockState(pos).getBlock();
                network.add(world, powerCellTileEntity2.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
                powerCellNetwork.save();
            }
        } else if (!stack.hasTagCompound() && !world.isRemote && (powerCellTileEntity = (PowerCellTileEntity)world.getTileEntity(pos)) != null && PowerCellBlock.isCreative((Block)this)) {
            powerCellTileEntity.setAllOutput();
        }
        if (placer instanceof EntityPlayer) {
            // empty if block
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess blockAccess, BlockPos pos, IBlockState state, int fortune) {
        PowerCellNetwork.Network network;
        TileEntity te;
        World world = (World)blockAccess;
        super.getDrops(drops, (IBlockAccess)world, pos, state, fortune);
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof PowerCellTileEntity && (network = ((PowerCellTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergySingleBlock(this.isAdvanced(), this.isSimple());
            if (!drops.isEmpty()) {
                NBTTagCompound tagCompound = ((ItemStack)drops.get(0)).getTagCompound();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).setTagCompound(tagCompound);
                }
                tagCompound.setInteger("energy", energy);
            }
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        PowerCellTileEntity cellTileEntity;
        PowerCellNetwork.Network network;
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof PowerCellTileEntity && (network = (cellTileEntity = (PowerCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            Block block = world.getBlockState(pos).getBlock();
            network.remove(world, cellTileEntity.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
            PowerCellNetwork.getChannels(world).save();
            cellTileEntity.setNetworkId(-1);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        PowerCellTileEntity cellTileEntity;
        PowerCellNetwork.Network network;
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof PowerCellTileEntity && (network = (cellTileEntity = (PowerCellTileEntity)te).getNetwork()) != null) {
            int a = network.extractEnergySingleBlock(this.isAdvanced(), this.isSimple());
            Block block = world.getBlockState(pos).getBlock();
            network.remove(world, cellTileEntity.getGlobalPos(), PowerCellBlock.isAdvanced(block), PowerCellBlock.isSimple(block));
            PowerCellNetwork.getChannels(world).save();
        }
        super.breakBlock(world, pos, state);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = world instanceof ChunkCache ? ((ChunkCache)world).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK) : world.getTileEntity(pos);
        if (tileEntity instanceof PowerCellTileEntity) {
            PowerCellTileEntity te = (PowerCellTileEntity)tileEntity;
            PowerCellTileEntity.Mode north = te.getMode(EnumFacing.NORTH);
            PowerCellTileEntity.Mode south = te.getMode(EnumFacing.SOUTH);
            PowerCellTileEntity.Mode west = te.getMode(EnumFacing.WEST);
            PowerCellTileEntity.Mode east = te.getMode(EnumFacing.EAST);
            PowerCellTileEntity.Mode up = te.getMode(EnumFacing.UP);
            PowerCellTileEntity.Mode down = te.getMode(EnumFacing.DOWN);
            return state.withProperty(NORTH, (Comparable)((Object)north)).withProperty(SOUTH, (Comparable)((Object)south)).withProperty(WEST, (Comparable)((Object)west)).withProperty(EAST, (Comparable)((Object)east)).withProperty(UP, (Comparable)((Object)up)).withProperty(DOWN, (Comparable)((Object)down));
        }
        return state.withProperty(NORTH, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).withProperty(SOUTH, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).withProperty(WEST, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).withProperty(EAST, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).withProperty(UP, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE)).withProperty(DOWN, (Comparable)((Object)PowerCellTileEntity.Mode.MODE_NONE));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState();
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }
}

