/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class NbtSanitizerModuleGuiBuilder
implements IModuleGuiBuilder {
    private final Map<String, Set<String>> enumKeys = new HashMap<String, Set<String>>();
    private final Set<String> stringKeys = new HashSet<String>();
    private final Map<String, Integer> boundedIntegerKeys = new HashMap<String, Integer>();
    private final Set<String> integerKeys = new HashSet<String>();
    private boolean hasModeKeys = false;
    private final Set<String> booleanKeys = new HashSet<String>();
    private final Set<String> itemKeys = new HashSet<String>();
    private final World world;
    @Nullable
    private final NBTTagCompound oldCompound;
    private static final Set<String> FORMAT_STRINGS = ImmutableSet.copyOf((Object[])((String[])Arrays.stream(FormatStyle.values()).map(FormatStyle::getName).toArray(String[]::new)));

    public NbtSanitizerModuleGuiBuilder(World world, @Nullable NBTTagCompound oldCompound) {
        this.world = world;
        this.oldCompound = oldCompound;
    }

    public NBTTagCompound sanitizeNbt(NBTTagCompound fromClient) {
        String key;
        NBTTagCompound newCompound = this.oldCompound != null ? this.oldCompound.copy() : new NBTTagCompound();
        for (Map.Entry<String, Set<String>> entry : this.enumKeys.entrySet()) {
            key = entry.getKey();
            if (!fromClient.hasKey(key, 8)) continue;
            String value = fromClient.getString(key);
            if (!entry.getValue().contains(value)) continue;
            newCompound.setString(key, value);
        }
        for (String string : this.stringKeys) {
            if (!fromClient.hasKey(string, 8)) continue;
            newCompound.setString(string, fromClient.getString(string));
        }
        for (Map.Entry entry : this.boundedIntegerKeys.entrySet()) {
            int value;
            key = (String)entry.getKey();
            if (!fromClient.hasKey(key, 3) || (value = fromClient.getInteger(key)) < 0 || value >= (Integer)entry.getValue()) continue;
            newCompound.setInteger(key, value);
        }
        for (String string : this.integerKeys) {
            if (!fromClient.hasKey(string, 3)) continue;
            newCompound.setInteger(string, fromClient.getInteger(string));
        }
        if (this.hasModeKeys && fromClient.hasKey("showdiff", 1) && fromClient.hasKey("showpct", 1) && fromClient.hasKey("hidetext", 1)) {
            boolean showdiff = fromClient.getBoolean("showdiff");
            boolean bl = fromClient.getBoolean("showpct");
            boolean hidetext = fromClient.getBoolean("hidetext");
            if (!(showdiff && bl || showdiff && hidetext || bl && hidetext)) {
                newCompound.setBoolean("showdiff", showdiff);
                newCompound.setBoolean("showpct", bl);
                newCompound.setBoolean("hidetext", hidetext);
            }
        }
        for (String string : this.booleanKeys) {
            if (!fromClient.hasKey(string, 1)) continue;
            newCompound.setBoolean(string, fromClient.getBoolean(string));
        }
        for (String string : this.itemKeys) {
            if (fromClient.hasKey(string, 10)) {
                NBTTagCompound tag = new NBTTagCompound();
                new ItemStack(fromClient.getCompoundTag(string)).writeToNBT(tag);
                newCompound.setTag(string, (NBTBase)tag);
                continue;
            }
            newCompound.removeTag(string);
        }
        return newCompound;
    }

    @Override
    public NBTTagCompound getCurrentData() {
        return this.oldCompound.copy();
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        this.enumKeys.put(tagname, (Set<String>)ImmutableSet.copyOf((Object[])choices));
        return this;
    }

    @Override
    public IModuleGuiBuilder format(String tagname) {
        this.enumKeys.put(tagname, FORMAT_STRINGS);
        return this;
    }

    @Override
    public IModuleGuiBuilder text(String tagname, String ... tooltip) {
        this.stringKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        this.boundedIntegerKeys.put(tagname, choices.length);
        return this;
    }

    @Override
    public IModuleGuiBuilder integer(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder color(String tagname, String ... tooltip) {
        this.integerKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder mode(String componentName) {
        this.hasModeKeys = true;
        return this;
    }

    @Override
    public IModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        this.booleanKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder ghostStack(String tagname) {
        this.itemKeys.add(tagname);
        return this;
    }

    @Override
    public IModuleGuiBuilder label(String text) {
        return this;
    }

    @Override
    public IModuleGuiBuilder leftLabel(String text) {
        return this;
    }

    @Override
    public IModuleGuiBuilder block(String tagname) {
        return this;
    }

    @Override
    public IModuleGuiBuilder nl() {
        return this;
    }
}

