/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.IScreenModuleUpdater;
import mcjty.rftools.api.screens.ITooltipInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StorageControlScreenModule
implements IScreenModule<ModuleDataStacks>,
ITooltipInfo,
IScreenModuleUpdater {
    private ItemStackList stacks = ItemStackList.create((int)9);
    protected int dim = 0;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean starred = false;
    private boolean oredict = false;
    private int dirty = -1;

    @Override
    public ModuleDataStacks getData(IScreenDataHelper helper, World worldObj, long millis) {
        StorageScannerTileEntity scannerTileEntity = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return null;
        }
        int[] amounts = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            amounts[i] = scannerTileEntity.countItems((ItemStack)this.stacks.get(i), this.starred, this.oredict);
        }
        return new ModuleDataStacks(amounts);
    }

    public static StorageScannerTileEntity getStorageScanner(int dim, BlockPos coordinate) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)coordinate)) {
            return null;
        }
        TileEntity te = world.getTileEntity(coordinate);
        if (te == null) {
            return null;
        }
        if (!(te instanceof StorageScannerTileEntity)) {
            return null;
        }
        return (StorageScannerTileEntity)te;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        StorageScannerTileEntity te;
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!tagCompound.hasKey("stack" + i)) continue;
                this.stacks.set(i, (Object)new ItemStack(tagCompound.getCompoundTag("stack" + i)));
            }
        }
        if ((te = StorageControlScreenModule.getStorageScanner(dim, this.coordinate)) != null) {
            te.clearCachedCounts();
        }
    }

    private int getHighlightedStack(int hitx, int hity) {
        int i = 0;
        for (int yy = 0; yy < 3; ++yy) {
            int y = 7 + yy * 35;
            for (int xx = 0; xx < 3; ++xx) {
                boolean hilighted;
                int x = xx * 40;
                boolean bl = hilighted = hitx >= x + 8 && hitx <= x + 38 && hity >= y - 7 && hity <= y + 22;
                if (hilighted) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public List<String> getInfo(World world, int x, int y) {
        int i;
        StorageScannerTileEntity te = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (te != null && (i = this.getHighlightedStack(x, y)) != -1 && !((ItemStack)this.stacks.get(i)).isEmpty()) {
            return Collections.singletonList(TextFormatting.GREEN + "Item: " + TextFormatting.WHITE + ((ItemStack)this.stacks.get(i)).getDisplayName());
        }
        return Collections.emptyList();
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.starred = tagCompound.getBoolean("starred");
        this.oredict = tagCompound.getBoolean("oredict");
        if (tagCompound.hasKey("monitorx")) {
            this.dim = tagCompound.hasKey("monitordim") ? tagCompound.getInteger("monitordim") : tagCompound.getInteger("dim");
            BlockPos c = new BlockPos(tagCompound.getInteger("monitorx"), tagCompound.getInteger("monitory"), tagCompound.getInteger("monitorz"));
            int dx = Math.abs(c.getX() - pos.getX());
            int dy = Math.abs(c.getY() - pos.getY());
            int dz = Math.abs(c.getZ() - pos.getZ());
            this.coordinate = c;
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    private boolean isShown(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageScannerTileEntity.isItemEqual(stack, s, this.oredict)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound update(NBTTagCompound tagCompound, World world, EntityPlayer player) {
        if (this.dirty >= 0) {
            NBTTagCompound newCompound = tagCompound.copy();
            NBTTagCompound tc = new NBTTagCompound();
            ((ItemStack)this.stacks.get(this.dirty)).writeToNBT(tc);
            newCompound.setTag("stack" + this.dirty, (NBTBase)tc);
            if (player != null) {
                SoundTools.playSound((World)player.getEntityWorld(), (SoundEvent)SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, (double)player.getPosition().getX(), (double)player.getPosition().getY(), (double)player.getPosition().getZ(), (double)1.0, (double)1.0);
            }
            this.dirty = -1;
            return newCompound;
        }
        return null;
    }

    @Override
    public void mouseClick(World world, int hitx, int hity, boolean clicked, EntityPlayer player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Module is not linked to storage scanner!"), false);
            return;
        }
        StorageScannerTileEntity scannerTileEntity = StorageControlScreenModule.getStorageScanner(this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        if (hitx >= 0) {
            boolean insertAllActive;
            boolean insertStackActive;
            boolean bl = insertStackActive = hitx >= 0 && hitx < 60 && hity > 98;
            if (insertStackActive) {
                if (this.isShown(player.getHeldItem(EnumHand.MAIN_HAND))) {
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.getHeldItem(EnumHand.MAIN_HAND), player);
                    player.setHeldItem(EnumHand.MAIN_HAND, stack);
                }
                player.openContainer.detectAndSendChanges();
                return;
            }
            boolean bl2 = insertAllActive = hitx >= 60 && hity > 98;
            if (insertAllActive) {
                for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
                    if (!this.isShown(player.inventory.getStackInSlot(i))) continue;
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.inventory.getStackInSlot(i), player);
                    player.inventory.setInventorySlotContents(i, stack);
                }
                player.openContainer.detectAndSendChanges();
                return;
            }
            int i = this.getHighlightedStack(hitx, hity);
            if (i != -1) {
                if (((ItemStack)this.stacks.get(i)).isEmpty()) {
                    ItemStack heldItem = player.getHeldItemMainhand();
                    if (!heldItem.isEmpty()) {
                        ItemStack stack = heldItem.copy();
                        stack.setCount(1);
                        this.stacks.set(i, (Object)stack);
                        this.dirty = i;
                    }
                } else {
                    scannerTileEntity.giveToPlayerFromScreen((ItemStack)this.stacks.get(i), player.isSneaking(), player, this.oredict);
                }
            }
        }
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftools:storage";
        private int[] amounts = null;

        @Override
        public String getId() {
            return ID;
        }

        public ModuleDataStacks(int ... amountsIn) {
            this.amounts = amountsIn;
        }

        public ModuleDataStacks(ByteBuf buf) {
            int s = buf.readInt();
            this.amounts = new int[s];
            for (int i = 0; i < s; ++i) {
                this.amounts[i] = buf.readInt();
            }
        }

        public int getAmount(int idx) {
            return this.amounts[idx];
        }

        @Override
        public void writeToBuf(ByteBuf buf) {
            buf.writeInt(this.amounts.length);
            for (int i : this.amounts) {
                buf.writeInt(i);
            }
        }
    }
}

