/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.lib.client.RenderHelper;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleDataBoolean;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ButtonClientScreenModule
implements IClientScreenModule<IModuleDataBoolean> {
    private String line = "";
    private String button = "";
    private boolean toggle = false;
    private int color = 0xFFFFFF;
    private int buttonColor = 0xFFFFFF;
    private boolean activated = false;
    private ITextRenderHelper labelCache = new ScreenTextHelper();
    private ITextRenderHelper buttonCache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataBoolean screenData, ModuleRenderInfo renderInfo) {
        int buttonWidth;
        int xoffset;
        GlStateManager.disableLighting();
        GlStateManager.enableDepth();
        GlStateManager.depthMask((boolean)false);
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 316, renderInfo);
            this.labelCache.renderText(0, currenty + 2, this.color, renderInfo);
            xoffset = 87;
            buttonWidth = 170;
        } else {
            xoffset = 12;
            buttonWidth = 490;
        }
        boolean act = false;
        if (this.toggle) {
            if (screenData != null) {
                act = screenData.get();
            }
        } else {
            act = this.activated;
        }
        RenderHelper.drawBeveledBox((int)(xoffset - 5), (int)currenty, (int)123, (int)(currenty + 12), (int)(act ? -13421773 : -1118482), (int)(act ? -1118482 : -13421773), (int)-10066330);
        this.buttonCache.setup(this.button, buttonWidth, renderInfo);
        this.buttonCache.renderText(xoffset - 10 + (act ? 1 : 0), currenty + 2, this.buttonColor, renderInfo);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
        int xoffset = !this.line.isEmpty() ? 80 : 5;
        this.activated = false;
        if (x >= xoffset) {
            this.activated = clicked;
        }
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.getString("text");
            this.button = tagCompound.getString("button");
            this.color = tagCompound.hasKey("color") ? tagCompound.getInteger("color") : 0xFFFFFF;
            this.buttonColor = tagCompound.hasKey("buttonColor") ? tagCompound.getInteger("buttonColor") : 0xFFFFFF;
            this.toggle = tagCompound.getBoolean("toggle");
            if (tagCompound.hasKey("align")) {
                String alignment = tagCompound.getString("align");
                this.labelCache.align(TextAlign.get(alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            this.buttonCache.setDirty();
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

