/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TextClientScreenModule
implements IClientScreenModule<IModuleData> {
    private String line = "";
    private int color = 0xFFFFFF;
    private ITextRenderHelper cache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return this.cache.isLarge() ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return this.cache.isLarge() ? 20 : 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        GlStateManager.disableLighting();
        this.cache.setup(this.line, 512, renderInfo);
        int y = this.cache.isLarge() ? currenty / 2 + 1 : currenty;
        this.cache.renderText(0, y, this.color, renderInfo);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setLine(String line) {
        this.line = line;
        this.cache.setDirty();
    }

    public void setColor(int color) {
        this.color = color;
        this.cache.setDirty();
    }

    public void setLarge(boolean large) {
        this.cache.large(large);
        this.cache.setDirty();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.getString("text");
            this.color = tagCompound.hasKey("color") ? tagCompound.getInteger("color") : 0xFFFFFF;
            this.cache.large(tagCompound.getBoolean("large"));
            if (tagCompound.hasKey("align")) {
                String alignment = tagCompound.getString("align");
                this.cache.align(TextAlign.get(alignment));
            } else {
                this.cache.align(TextAlign.ALIGN_LEFT);
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return false;
    }
}

