/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class SecurityChannels
extends AbstractWorldData<SecurityChannels> {
    private static final String SECURITY_CHANNELS_NAME = "RFToolsSecurityChannels";
    private int lastId = 0;
    private final Map<Integer, SecurityChannel> channels = new HashMap<Integer, SecurityChannel>();

    public SecurityChannels(String name) {
        super(name);
    }

    public void clear() {
        this.channels.clear();
        this.lastId = 0;
    }

    public static SecurityChannels getChannels(World world) {
        return (SecurityChannels)SecurityChannels.getData((World)world, SecurityChannels.class, (String)SECURITY_CHANNELS_NAME);
    }

    public SecurityChannel getOrCreateChannel(int id) {
        SecurityChannel channel = this.channels.get(id);
        if (channel == null) {
            channel = new SecurityChannel();
            this.channels.put(id, channel);
        }
        return channel;
    }

    public SecurityChannel getChannel(int id) {
        return this.channels.get(id);
    }

    public void deleteChannel(int id) {
        this.channels.remove(id);
    }

    public int newChannel() {
        ++this.lastId;
        return this.lastId;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.channels.clear();
        NBTTagList lst = tagCompound.getTagList("channels", 10);
        for (int i = 0; i < lst.tagCount(); ++i) {
            NBTTagCompound tc = lst.getCompoundTagAt(i);
            int channel = tc.getInteger("channel");
            SecurityChannel value = new SecurityChannel();
            value.setName(tc.getString("name"));
            value.setWhitelist(tc.getBoolean("whitelist"));
            value.clearPlayers();
            NBTTagList playerList = tc.getTagList("players", 8);
            if (playerList != null) {
                for (int j = 0; j < playerList.tagCount(); ++j) {
                    String player = playerList.getStringTagAt(j);
                    value.addPlayer(player);
                }
            }
            this.channels.put(channel, value);
        }
        this.lastId = tagCompound.getInteger("lastId");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, SecurityChannel> entry : this.channels.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.setInteger("channel", entry.getKey().intValue());
            SecurityChannel channel = entry.getValue();
            tc.setString("name", channel.getName());
            tc.setBoolean("whitelist", channel.isWhitelist());
            NBTTagList playerTagList = new NBTTagList();
            for (String player : channel.getPlayers()) {
                playerTagList.appendTag((NBTBase)new NBTTagString(player));
            }
            tc.setTag("players", (NBTBase)playerTagList);
            lst.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("channels", (NBTBase)lst);
        tagCompound.setInteger("lastId", this.lastId);
        return tagCompound;
    }

    public static class SecurityChannel {
        private String name = "";
        private boolean whitelist = true;
        private final List<String> players = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getPlayers() {
            return this.players;
        }

        public void addPlayer(String player) {
            this.players.add(player);
        }

        public void delPlayer(String player) {
            this.players.remove(player);
        }

        public void clearPlayers() {
            this.players.clear();
        }

        public boolean isWhitelist() {
            return this.whitelist;
        }

        public void setWhitelist(boolean whitelist) {
            this.whitelist = whitelist;
        }
    }
}

