/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractShieldBlock
extends Block
implements ITileEntityProvider {
    public static final int META_ITEMS = 1;
    public static final int META_PASSIVE = 2;
    public static final int META_HOSTILE = 4;
    public static final int META_PLAYERS = 8;
    public static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.002, 0.002, 0.002, 0.998, 0.998, 0.998);

    public AbstractShieldBlock(String registryName, String unlocName, boolean opaque) {
        super(Material.GLASS);
        this.lightOpacity = opaque ? 255 : 0;
        this.setRegistryName(registryName);
        this.setTranslationKey(unlocName);
        this.setBlockUnbreakable();
        this.setResistance(6000000.0f);
        McJtyRegister.registerLater((Block)this, (ModBase)RFTools.instance, ItemBlock::new);
    }

    public static boolean activateBlock(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public static Collection<IProperty<?>> getPropertyKeys(IBlockState state) {
        return state.getPropertyKeys();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isBlockNormalCube(IBlockState state) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public EnumPushReaction getPushReaction(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_BOX;
    }

    public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> list, @Nullable Entity entity, boolean p_185477_7_) {
        NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)world.getTileEntity(pos);
        int cdData = shieldBlockTileEntity.getCollisionData();
        if (cdData == 0) {
            return;
        }
        if ((cdData & 4) != 0 && entity instanceof IMob) {
            if (this.checkEntityCD(world, pos, "hostile")) {
                super.addCollisionBoxToList(state, world, pos, entityBox, list, entity, p_185477_7_);
            }
            return;
        }
        if ((cdData & 2) != 0 && entity instanceof IAnimals && !(entity instanceof IMob)) {
            if (this.checkEntityCD(world, pos, "animal")) {
                super.addCollisionBoxToList(state, world, pos, entityBox, list, entity, p_185477_7_);
            }
            return;
        }
        if ((cdData & 8) != 0 && entity instanceof EntityPlayer && this.checkPlayerCD(world, pos, (EntityPlayer)entity)) {
            super.addCollisionBoxToList(state, world, pos, entityBox, list, entity, p_185477_7_);
        }
        if ((cdData & 1) != 0 && !(entity instanceof EntityLivingBase)) {
            if (this.checkEntityCD(world, pos, "item")) {
                super.addCollisionBoxToList(state, world, pos, entityBox, list, entity, p_185477_7_);
            }
            return;
        }
    }

    private boolean checkEntityCD(World world, BlockPos pos, String filterName) {
        ShieldTEBase shieldTileEntity;
        NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)world.getTileEntity(pos);
        BlockPos shieldBlock = shieldBlockTileEntity.getShieldBlock();
        if (shieldBlock != null && (shieldTileEntity = (ShieldTEBase)world.getTileEntity(shieldBlock)) != null) {
            List<ShieldFilter> filters = shieldTileEntity.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!filterName.equals(filter.getFilterName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    private boolean checkPlayerCD(World world, BlockPos pos, EntityPlayer entity) {
        ShieldTEBase shieldTileEntity;
        NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)world.getTileEntity(pos);
        BlockPos shieldBlock = shieldBlockTileEntity.getShieldBlock();
        if (shieldBlock != null && (shieldTileEntity = (ShieldTEBase)world.getTileEntity(shieldBlock)) != null) {
            List<ShieldFilter> filters = shieldTileEntity.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!"player".equals(filter.getFilterName())) continue;
                PlayerFilter playerFilter = (PlayerFilter)filter;
                String name = playerFilter.getName();
                if (name == null || name.isEmpty()) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!name.equals(entity.getName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        int cdData;
        NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)world.getTileEntity(pos);
        if (!(entity instanceof EntityLivingBase) && ((cdData = shieldBlockTileEntity.getCollisionData()) & 1) == 0) {
            entity.setPosition(entity.posX, entity.posY - 1.0, entity.posZ);
        }
        shieldBlockTileEntity.handleDamage(entity);
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos thispos, EnumFacing side) {
        BlockPos pos = thispos.offset(side);
        NoTickShieldBlockTileEntity shieldBlockTileEntity = (NoTickShieldBlockTileEntity)world.getTileEntity(thispos);
        if (shieldBlockTileEntity == null) {
            return super.shouldSideBeRendered(state, world, pos, side);
        }
        IBlockState mimic = shieldBlockTileEntity.getMimicBlock();
        if (mimic == null) {
            return super.shouldSideBeRendered(state, world, pos, side);
        }
        return mimic.getBlock().shouldSideBeRendered(state, world, pos, side);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new NoTickShieldBlockTileEntity();
    }
}

