/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.TickShieldSolidBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolidShieldBlock
extends AbstractShieldBlock {
    public static final PropertyInteger ICON_TOPDOWN = PropertyInteger.create((String)"icontopdown", (int)0, (int)5);
    public static final PropertyInteger ICON_SIDE = PropertyInteger.create((String)"iconside", (int)0, (int)5);

    public SolidShieldBlock(String registryName, String unlocName, boolean opaque) {
        super(registryName, unlocName, opaque);
    }

    @SideOnly(value=Side.CLIENT)
    public void initBlockColors() {
        Minecraft.getMinecraft().getBlockColors().registerBlockColorHandler((state, worldIn, pos, tintIndex) -> {
            TileEntity te;
            if (pos != null && worldIn != null && (te = worldIn.getTileEntity(pos)) instanceof NoTickShieldBlockTileEntity) {
                NoTickShieldBlockTileEntity tileEntity = (NoTickShieldBlockTileEntity)te;
                return tileEntity.getShieldColor();
            }
            return 0xFFFFFF;
        }, new Block[]{this});
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TickShieldSolidBlockTileEntity();
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = world.getBlockState(pos.offset(side)).getBlock();
        return !(block instanceof SolidShieldBlock);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK) : world.getTileEntity(pos);
        if (te instanceof NoTickShieldBlockTileEntity) {
            NoTickShieldBlockTileEntity tileEntity2 = (NoTickShieldBlockTileEntity)te;
            ShieldRenderingMode mode = tileEntity2.getShieldRenderingMode();
            if (mode == ShieldRenderingMode.MODE_TRANSP) {
                return state.withProperty((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(4)).withProperty((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(4));
            }
            if (mode == ShieldRenderingMode.MODE_SOLID) {
                return state.withProperty((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(5)).withProperty((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(5));
            }
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int topdown = (z & 1) * 2 + (x & 1);
        int side = (y & 1) * 2 + (x + z & 1);
        return state.withProperty((IProperty)ICON_TOPDOWN, (Comparable)Integer.valueOf(topdown)).withProperty((IProperty)ICON_SIDE, (Comparable)Integer.valueOf(side));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState();
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ICON_TOPDOWN, ICON_SIDE});
    }
}

