/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield.filters;

import io.netty.buffer.ByteBuf;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.shield.filters.AnimalFilter;
import mcjty.rftools.blocks.shield.filters.DefaultFilter;
import mcjty.rftools.blocks.shield.filters.HostileFilter;
import mcjty.rftools.blocks.shield.filters.ItemFilter;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class AbstractShieldFilter
implements ShieldFilter {
    private int action = 0;

    @Override
    public int getAction() {
        return this.action;
    }

    @Override
    public void setAction(int action) {
        this.action = action;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.action = tagCompound.getInteger("action");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.setString("type", this.getFilterName());
        tagCompound.setInteger("action", this.action);
    }

    public static ShieldFilter createFilter(ByteBuf buf) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        return AbstractShieldFilter.createFilter(compound);
    }

    public static ShieldFilter createFilter(NBTTagCompound compound) {
        String type = compound.getString("type");
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.readFromNBT(compound);
        return filter;
    }

    public static ShieldFilter createFilter(String type) {
        AbstractShieldFilter filter;
        if ("animal".equals(type)) {
            filter = new AnimalFilter();
        } else if ("hostile".equals(type)) {
            filter = new HostileFilter();
        } else if ("player".equals(type)) {
            filter = new PlayerFilter();
        } else if ("item".equals(type)) {
            filter = new ItemFilter();
        } else if ("default".equals(type)) {
            filter = new DefaultFilter();
        } else {
            Logging.log((String)("Unknown filter type = " + type));
            filter = new DefaultFilter();
        }
        return filter;
    }
}

