/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield.filters;

import mcjty.rftools.blocks.shield.filters.AbstractShieldFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerFilter
extends AbstractShieldFilter {
    public static final String PLAYER = "player";
    private String name = null;

    public PlayerFilter() {
    }

    public PlayerFilter(String name) {
        this.name = name;
    }

    @Override
    public String getFilterName() {
        return PLAYER;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean match(Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if (this.name == null) {
            return true;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        return this.name.equals(entityPlayer.getName());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.name = tagCompound.getString("name");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setString("name", this.name);
    }
}

