/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import mcjty.lib.client.RenderGlowEffect;
import mcjty.lib.client.RenderHelper;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class MatterBeamerRenderer
extends TileEntitySpecialRenderer<MatterBeamerTileEntity> {
    private static final ResourceLocation redglow = new ResourceLocation("rftools", "textures/blocks/redglow.png");
    private static final ResourceLocation blueglow = new ResourceLocation("rftools", "textures/blocks/blueglow.png");

    public void render(MatterBeamerTileEntity tileEntity, double x, double y, double z, float time, int destroyStage, float alpha) {
        BlockPos coord;
        Object txt;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        BlockPos destination = tileEntity.getDestination();
        if (destination != null && tileEntity.isPowered()) {
            GlStateManager.pushMatrix();
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
            GlStateManager.depthMask((boolean)false);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)1, (int)1);
            Minecraft mc = Minecraft.getMinecraft();
            EntityPlayerSP p = mc.player;
            double doubleX = p.lastTickPosX + (p.posX - p.lastTickPosX) * (double)time;
            double doubleY = p.lastTickPosY + (p.posY - p.lastTickPosY) * (double)time;
            double doubleZ = p.lastTickPosZ + (p.posZ - p.lastTickPosZ) * (double)time;
            RenderHelper.Vector start = new RenderHelper.Vector((float)tileEntity.getPos().getX() + 0.5f, (float)tileEntity.getPos().getY() + 0.5f, (float)tileEntity.getPos().getZ() + 0.5f);
            RenderHelper.Vector end = new RenderHelper.Vector((float)destination.getX() + 0.5f, (float)destination.getY() + 0.5f, (float)destination.getZ() + 0.5f);
            RenderHelper.Vector player = new RenderHelper.Vector((float)doubleX, (float)doubleY + p.getEyeHeight(), (float)doubleZ);
            GlStateManager.translate((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            this.bindTexture(redglow);
            RenderHelper.drawBeam((RenderHelper.Vector)start, (RenderHelper.Vector)end, (RenderHelper.Vector)player, (float)(tileEntity.isGlowing() ? 0.1f : 0.05f));
            tessellator.draw();
            GlStateManager.popMatrix();
        }
        if ((txt = (coord = tileEntity.getPos()).equals((Object)RFTools.instance.clientInfo.getSelectedTE()) ? redglow : (coord.equals((Object)RFTools.instance.clientInfo.getDestinationTE()) ? blueglow : null)) != null) {
            this.bindTexture((ResourceLocation)txt);
            RenderGlowEffect.renderGlow((Tessellator)tessellator, (double)x, (double)y, (double)z);
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(MatterBeamerTileEntity.class, (TileEntitySpecialRenderer)new MatterBeamerRenderer());
    }
}

