/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.storage.GuiModularStorage;
import mcjty.rftools.blocks.storage.ModularAmountOverlay;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.ModularTypeModule;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ModularStorageBlock
extends GenericRFToolsBlock<ModularStorageTileEntity, ModularStorageContainer> {
    public static final PropertyEnum<ModularTypeModule> TYPEMODULE = PropertyEnum.create((String)"type", ModularTypeModule.class);
    public static final PropertyEnum<ModularAmountOverlay> AMOUNT = PropertyEnum.create((String)"amount", ModularAmountOverlay.class);
    public static int cntReceived = 1;
    public static String nameModuleReceived = "";
    private static long lastTime = 0L;

    public ModularStorageBlock() {
        super(Material.IRON, ModularStorageTileEntity.class, ModularStorageContainer::new, "modular_storage", true);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<ModularStorageTileEntity, ModularStorageContainer, GenericGuiContainer<? super ModularStorageTileEntity>> getGuiFactory() {
        return GuiModularStorage::new;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
    }

    public int getGuiID() {
        return GuiProxy.GUI_MODULAR_STORAGE;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This modular storage system can store a lot");
            list.add(TextFormatting.WHITE + "of items and allows easy searching and filtering.");
            list.add(TextFormatting.WHITE + "You must first insert a storage module item before");
            list.add(TextFormatting.WHITE + "you can use it");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = world instanceof ChunkCache ? ((ChunkCache)world).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK) : world.getTileEntity(pos);
        if (tileEntity instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity te = (ModularStorageTileEntity)tileEntity;
            ItemStack stack = te.getInventoryHelper().getStackInSlot(1);
            int level = te.getRenderLevel();
            int remoteId = te.getRemoteId();
            ModularAmountOverlay p = ModularAmountOverlay.AMOUNT_NONE;
            if (remoteId > 0) {
                switch (level) {
                    case -1: {
                        p = ModularAmountOverlay.AMOUNT_NONE;
                        break;
                    }
                    case 0: {
                        p = ModularAmountOverlay.AMOUNT_R0;
                        break;
                    }
                    case 1: {
                        p = ModularAmountOverlay.AMOUNT_R1;
                        break;
                    }
                    case 2: {
                        p = ModularAmountOverlay.AMOUNT_R2;
                        break;
                    }
                    case 3: {
                        p = ModularAmountOverlay.AMOUNT_R3;
                        break;
                    }
                    case 4: {
                        p = ModularAmountOverlay.AMOUNT_R4;
                        break;
                    }
                    case 5: {
                        p = ModularAmountOverlay.AMOUNT_R5;
                        break;
                    }
                    case 6: {
                        p = ModularAmountOverlay.AMOUNT_R6;
                        break;
                    }
                    case 7: {
                        p = ModularAmountOverlay.AMOUNT_R7;
                    }
                }
            } else {
                switch (level) {
                    case -1: {
                        p = ModularAmountOverlay.AMOUNT_NONE;
                        break;
                    }
                    case 0: {
                        p = ModularAmountOverlay.AMOUNT_G0;
                        break;
                    }
                    case 1: {
                        p = ModularAmountOverlay.AMOUNT_G1;
                        break;
                    }
                    case 2: {
                        p = ModularAmountOverlay.AMOUNT_G2;
                        break;
                    }
                    case 3: {
                        p = ModularAmountOverlay.AMOUNT_G3;
                        break;
                    }
                    case 4: {
                        p = ModularAmountOverlay.AMOUNT_G4;
                        break;
                    }
                    case 5: {
                        p = ModularAmountOverlay.AMOUNT_G5;
                        break;
                    }
                    case 6: {
                        p = ModularAmountOverlay.AMOUNT_G6;
                        break;
                    }
                    case 7: {
                        p = ModularAmountOverlay.AMOUNT_G7;
                    }
                }
            }
            IBlockState newstate = state.withProperty(AMOUNT, (Comparable)((Object)p));
            if (stack.isEmpty()) {
                return newstate.withProperty(TYPEMODULE, (Comparable)((Object)ModularTypeModule.TYPE_NONE));
            }
            if (stack.getItem() == ModularStorageSetup.genericTypeItem) {
                return newstate.withProperty(TYPEMODULE, (Comparable)((Object)ModularTypeModule.TYPE_GENERIC));
            }
            if (stack.getItem() == ModularStorageSetup.oreDictTypeItem) {
                return newstate.withProperty(TYPEMODULE, (Comparable)((Object)ModularTypeModule.TYPE_ORE));
            }
            return newstate.withProperty(TYPEMODULE, (Comparable)((Object)ModularTypeModule.TYPE_NONE));
        }
        return super.getActualState(state, world, pos);
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(2){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.getItem() == ModularStorageSetup.storageFilterItem;
            }
        };
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPEMODULE, AMOUNT});
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.getTileEntity(data.getPos());
        if (te instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            int maxSize = modularStorageTileEntity.getMaxSize();
            if (maxSize == 0) {
                probeInfo.text(TextFormatting.YELLOW + "No storage module!");
            } else {
                int stacks;
                ItemStack storageModule = modularStorageTileEntity.getStackInSlot(0);
                if (!storageModule.isEmpty() && storageModule.getTagCompound().hasKey("display")) {
                    probeInfo.text(TextFormatting.YELLOW + "Module: " + TextFormatting.WHITE + storageModule.getDisplayName());
                }
                if ((stacks = modularStorageTileEntity.getNumStacks()) == -1) {
                    probeInfo.text(TextFormatting.YELLOW + "Maximum size: " + maxSize);
                } else {
                    probeInfo.text(TextFormatting.GREEN + "" + stacks + " out of " + maxSize);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            int maxSize = modularStorageTileEntity.getMaxSize();
            if (maxSize == 0) {
                currenttip.add(TextFormatting.YELLOW + "No storage module!");
            } else {
                int stacks;
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.sendToServer("requestStorageInfo", TypedMap.builder().put(CommandHandler.PARAM_DIMENSION, (Object)modularStorageTileEntity.getWorld().provider.getDimension()).put(CommandHandler.PARAM_POS, (Object)modularStorageTileEntity.getPos()));
                }
                if (!nameModuleReceived.isEmpty()) {
                    currenttip.add(TextFormatting.YELLOW + "Module: " + TextFormatting.WHITE + nameModuleReceived);
                }
                if ((stacks = cntReceived) == -1) {
                    currenttip.add(TextFormatting.YELLOW + "Maximum size: " + maxSize);
                } else {
                    currenttip.add(TextFormatting.GREEN + "" + stacks + " out of " + maxSize);
                }
            }
        }
        return currenttip;
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ((ModularStorageTileEntity)tileEntity).markDirtyClient();
        return super.createServerContainer(entityPlayer, tileEntity);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            // empty if block
        }
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.getTileEntity(pos);
        if (te instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity mste = (ModularStorageTileEntity)te;
            return MathHelper.floor((float)((float)mste.getNumStacks() / (float)mste.getMaxSize() * 14.0f)) + (mste.getNumStacks() > 0 ? 1 : 0);
        }
        return 0;
    }
}

