/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.general.IInventoryTracker;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.items.storage.StorageTypeItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModularStorageTileEntity
extends GenericTileEntity
implements ITickable,
DefaultSidedInventory,
IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor {
    public static final String CMD_SETTINGS = "storage.settings";
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final String ACTION_COMPACT = "compact";
    public static final String ACTION_CYCLE = "cycle";
    public static final String ACTION_CLEARGRID = "clearGrid";
    private int[] accessible = null;
    private int maxSize = 0;
    private int version = 0;
    private StorageFilterCache filterCache = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ModularStorageContainer.factory, 303);
    private CraftingGrid craftingGrid = new CraftingGrid();
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";
    private int numStacks = -1;
    private int remoteId = 0;
    private int prevLevel = -3;
    private int timer = 10;
    private RemoteStorageTileEntity cachedRemoteStorage;
    private int cachedRemoteStorageId;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_COMPACT, this::compact), new DefaultAction(ACTION_CYCLE, this::cycle), new DefaultAction(ACTION_CLEARGRID, this::clearGrid)};
    }

    protected boolean needsCustomInvWrapper() {
        return false;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 10;
        this.cachedRemoteStorage = null;
        this.cachedRemoteStorageId = -1;
        if (this.isRemote()) {
            int level;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            int si = -1;
            if (storageTileEntity != null) {
                si = storageTileEntity.findRemoteIndex(this.remoteId);
            }
            if (si == -1) {
                if (this.prevLevel != -2) {
                    this.prevLevel = -2;
                    this.clearInventory();
                }
                return;
            }
            this.numStacks = storageTileEntity.getCount(si);
            int newMaxSize = storageTileEntity.getMaxStacks(si);
            if (newMaxSize != this.maxSize) {
                this.setMaxSize(newMaxSize);
            }
            if ((level = this.getRenderLevel()) != this.prevLevel) {
                this.prevLevel = level;
                this.markDirtyClient();
            }
        }
    }

    private void clearInventory() {
        this.setMaxSize(0);
        this.numStacks = -1;
        for (int i = 3; i < 300; ++i) {
            this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), i, ItemStack.EMPTY);
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.markDirty();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setInventorySlotContents(i, stacks.get(i));
        }
        this.markDirty();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.markDirty();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayer player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.inventory, 0).add((IInventory)this, 3);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        this.updateStackCount();
        return new int[0];
    }

    public int[] getSlotsForFace(EnumFacing side) {
        if (this.accessible == null) {
            this.accessible = new int[this.maxSize];
            for (int i = 0; i < this.maxSize; ++i) {
                this.accessible[i] = 3 + i;
            }
        }
        return this.accessible;
    }

    public boolean canInsertItem(int index, ItemStack stack, EnumFacing direction) {
        return index >= 3 && this.isItemValidForSlot(index, stack);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return index >= 3 && this.isItemValidForSlot(index, stack);
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.markDirty();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.markDirty();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.markDirty();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.markDirty();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSizeInventory() {
        return 3 + this.maxSize;
    }

    private boolean containsItem(int index) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= slots.size()) {
                return false;
            }
            return !((ItemStack)slots.get(index)).isEmpty();
        }
        return this.inventoryHelper.containsItem(index);
    }

    private boolean isStorageAvailableRemotely(int index) {
        return this.isServer() && this.isRemote() && index >= 3;
    }

    private boolean isRemote() {
        return this.remoteId != 0;
    }

    public int getRemoteId() {
        return this.remoteId;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.getSizeInventory()) {
            return ItemStack.EMPTY;
        }
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.EMPTY;
            }
            ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= slots.size()) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)slots.get(index);
        }
        return this.inventoryHelper.getStackInSlot(index);
    }

    private void handleNewAmount(boolean containsBefore, int index) {
        if (index < 3) {
            return;
        }
        boolean containsAfter = this.containsItem(index);
        if (containsBefore == containsAfter) {
            return;
        }
        int rlold = this.getRenderLevel();
        this.numStacks = containsBefore ? --this.numStacks : ++this.numStacks;
        StorageModuleItem.updateStackSize(this.getStackInSlot(0), this.numStacks);
        int rlnew = this.getRenderLevel();
        if (rlold != rlnew) {
            this.markDirtyClient();
        }
    }

    public int getRenderLevel() {
        if (this.numStacks == -1 || this.maxSize == 0) {
            return -1;
        }
        return (this.numStacks + 6) * 7 / this.maxSize;
    }

    public int getNumStacks() {
        return this.numStacks;
    }

    public ItemStack removeStackFromSlot(int index) {
        ++this.version;
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.EMPTY;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return ItemStack.EMPTY;
            }
            storageTileEntity.updateVersion();
            return storageTileEntity.removeStackFromSlotRemote(si, index);
        }
        boolean containsBefore = this.containsItem(index);
        ItemStack stack = this.inventoryHelper.removeStackFromSlot(index);
        this.handleNewAmount(containsBefore, index);
        return stack;
    }

    private ItemStack decrStackSizeHelper(int index, int amount) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.EMPTY;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return ItemStack.EMPTY;
            }
            storageTileEntity.updateVersion();
            return storageTileEntity.decrStackSizeRemote(si, index, amount);
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack decrStackSize(int index, int amount) {
        ++this.version;
        if (index == 0 && !this.getWorld().isRemote) {
            this.copyToModule();
        }
        boolean containsBefore = this.containsItem(index);
        ItemStack itemStack = this.decrStackSizeHelper(index, amount);
        this.handleNewAmount(containsBefore, index);
        if (index == 0) {
            ItemStack stackInSlot = this.inventoryHelper.getStackInSlot(0);
            this.copyFromModule(stackInSlot);
        }
        return itemStack;
    }

    private void setInventorySlotContentsHelper(int limit, int index, ItemStack stack) {
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            storageTileEntity.updateVersion();
            storageTileEntity.updateRemoteSlot(si, limit, index, stack);
        } else {
            this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        }
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        ++this.version;
        if (index == 0) {
            if (this.isServer()) {
                this.copyToModule();
            }
        } else if (index == 1) {
            IBlockState state = this.getWorld().getBlockState(this.getPos());
            this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 3);
        } else if (index == 2) {
            this.filterCache = null;
        }
        boolean containsBefore = this.containsItem(index);
        this.setInventorySlotContentsHelper(this.getInventoryStackLimit(), index, stack);
        if (index == 0 && this.isServer()) {
            this.copyFromModule(stack);
        }
        this.handleNewAmount(containsBefore, index);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index >= this.getSizeInventory()) {
            return false;
        }
        switch (index) {
            case 0: {
                return !stack.isEmpty() && ModularStorageSetup.storageModuleItem == stack.getItem();
            }
            case 2: {
                return !stack.isEmpty() && stack.getItem() instanceof StorageFilterItem;
            }
            case 1: {
                return !stack.isEmpty() && stack.getItem() instanceof StorageTypeItem;
            }
        }
        if (index < 3) {
            return true;
        }
        if (this.isStorageAvailableRemotely(index)) {
            index -= 3;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStackList stacks = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= stacks.size()) {
                return false;
            }
        }
        if (this.inventoryHelper.containsItem(2)) {
            this.getFilterCache();
            if (this.filterCache != null) {
                return this.filterCache.match(stack);
            }
        }
        return true;
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(2));
        }
    }

    public void copyToModule() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItemDamage() == 6) {
            this.remoteId = 0;
            return;
        }
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.setTagCompound(tagCompound);
        }
        int cnt = this.writeBufferToItemNBT(tagCompound);
        tagCompound.setInteger("count", cnt);
    }

    public void copyFromModule(ItemStack stack) {
        for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
            this.inventoryHelper.setInventorySlotContents(0, i, ItemStack.EMPTY);
        }
        if (stack.isEmpty()) {
            this.clearInventory();
            return;
        }
        this.remoteId = 0;
        if (stack.getItemDamage() == 6) {
            NBTTagCompound tagCompound = stack.getTagCompound();
            if (tagCompound == null || !tagCompound.hasKey("id")) {
                this.clearInventory();
                return;
            }
            this.remoteId = tagCompound.getInteger("id");
            RemoteStorageTileEntity remoteStorageTileEntity = this.getRemoteStorage(this.remoteId);
            if (remoteStorageTileEntity == null) {
                this.clearInventory();
                return;
            }
            ItemStack storageStack = remoteStorageTileEntity.findStorageWithId(this.remoteId);
            if (storageStack.isEmpty()) {
                this.clearInventory();
                return;
            }
            this.setMaxSize(StorageModuleItem.MAXSIZE[storageStack.getItemDamage()]);
        } else {
            this.setMaxSize(StorageModuleItem.MAXSIZE[stack.getItemDamage()]);
            NBTTagCompound tagCompound = stack.getTagCompound();
            if (tagCompound != null) {
                this.readBufferFromItemNBT(tagCompound);
            }
        }
        this.updateStackCount();
    }

    private RemoteStorageTileEntity getRemoteStorage(int id) {
        if (id != this.cachedRemoteStorageId) {
            this.cachedRemoteStorage = null;
        }
        if (this.cachedRemoteStorage != null) {
            return this.cachedRemoteStorage;
        }
        World world = this.getWorldSafe();
        this.cachedRemoteStorage = RemoteStorageIdRegistry.getRemoteStorage(world, id);
        this.cachedRemoteStorageId = this.cachedRemoteStorage != null ? id : -1;
        return this.cachedRemoteStorage;
    }

    private void updateStackCount() {
        this.numStacks = 0;
        if (this.isServer() && this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            ItemStackList stacks = storageTileEntity.getRemoteStacks(si);
            for (int i = 0; i < Math.min(this.maxSize, stacks.size()); ++i) {
                if (((ItemStack)stacks.get(i)).isEmpty()) continue;
                ++this.numStacks;
            }
            storageTileEntity.updateCount(si, this.numStacks);
        } else {
            for (int i = 3; i < 3 + this.maxSize; ++i) {
                if (!this.inventoryHelper.containsItem(i)) continue;
                ++this.numStacks;
            }
        }
        StorageModuleItem.updateStackSize(this.getStackInSlot(0), this.numStacks);
    }

    private boolean isServer() {
        if (this.getWorld() != null) {
            return !this.getWorld().isRemote;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    private World getWorldSafe() {
        Object world = this.getWorld();
        if (world == null) {
            world = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? RFTools.proxy.getClientWorld() : DimensionManager.getWorld((int)0);
        }
        return world;
    }

    private void setMaxSize(int ms) {
        this.maxSize = ms;
        this.inventoryHelper.setNewCount(3 + this.maxSize);
        this.accessible = null;
        this.markDirtyClient();
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.numStacks = tagCompound.getInteger("numStacks");
        this.maxSize = tagCompound.getInteger("maxSize");
        this.remoteId = tagCompound.getInteger("remoteId");
        this.inventoryHelper.setNewCount(3 + this.maxSize);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("numStacks", this.numStacks);
        tagCompound.setInteger("maxSize", this.maxSize);
        tagCompound.setInteger("remoteId", this.remoteId);
    }

    public void syncInventoryFromServer(int maxSize, int numStacks, String sortMode, String viewMode, boolean groupMode, String filter) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.numStacks = numStacks;
        this.maxSize = maxSize;
        int newcount = 3 + maxSize;
        if (newcount != this.inventoryHelper.getCount()) {
            this.inventoryHelper.setNewCount(newcount);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.numStacks = tagCompound.getInteger("numStacks");
        this.maxSize = tagCompound.getInteger("maxSize");
        this.remoteId = tagCompound.getInteger("remoteId");
        this.sortMode = tagCompound.getString("sortMode");
        this.viewMode = tagCompound.getString("viewMode");
        this.groupMode = tagCompound.getBoolean("groupMode");
        this.version = tagCompound.getInteger("version");
        this.filter = tagCompound.getString("filter");
        this.inventoryHelper.setNewCount(3 + this.maxSize);
        this.accessible = null;
        this.readBufferFromNBT(tagCompound);
        this.craftingGrid.readFromNBT(tagCompound.getCompoundTag("grid"));
        if (this.isServer()) {
            this.updateStackCount();
        }
    }

    private void readBufferFromItemNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
        for (int i = 0; i < bufferTagList.tagCount(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.inventoryHelper.setStackInSlot(i + 3, new ItemStack(nbtTagCompound));
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
        if (tagCompound.hasKey("SlotStorage")) {
            for (int i = 0; i < bufferTagList.tagCount(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
                this.inventoryHelper.setStackInSlot(i + 3, new ItemStack(nbtTagCompound));
            }
            this.inventoryHelper.setStackInSlot(0, new ItemStack(tagCompound.getCompoundTag("SlotStorage")));
            this.inventoryHelper.setStackInSlot(1, new ItemStack(tagCompound.getCompoundTag("SlotType")));
            this.inventoryHelper.setStackInSlot(2, new ItemStack(tagCompound.getCompoundTag("SlotFilter")));
        } else {
            int index = 0;
            for (int i = 0; i < bufferTagList.tagCount(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
                this.inventoryHelper.setStackInSlot(index, new ItemStack(nbtTagCompound));
                if (++index != 2) continue;
                ++index;
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        this.writeSlot(tagCompound, 0, "SlotStorage");
        this.writeSlot(tagCompound, 1, "SlotType");
        this.writeSlot(tagCompound, 2, "SlotFilter");
        tagCompound.setInteger("numStacks", this.numStacks);
        tagCompound.setInteger("maxSize", this.maxSize);
        tagCompound.setInteger("remoteId", this.remoteId);
        tagCompound.setString("sortMode", this.sortMode);
        tagCompound.setString("viewMode", this.viewMode);
        tagCompound.setBoolean("groupMode", this.groupMode);
        tagCompound.setString("filter", this.filter);
        tagCompound.setInteger("version", this.version);
        tagCompound.setTag("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    private void writeSlot(NBTTagCompound tagCompound, int index, String name) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        ItemStack stack = this.inventoryHelper.getStackInSlot(index);
        if (!stack.isEmpty()) {
            stack.writeToNBT(nbtTagCompound);
        }
        tagCompound.setTag(name, (NBTBase)nbtTagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        boolean sendToClient = this.isServer() && this.isRemote();
        NBTTagList bufferTagList = new NBTTagList();
        if (sendToClient) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity != null) {
                ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
                for (ItemStack stack : slots) {
                    NBTTagCompound nbtTagCompound = new NBTTagCompound();
                    if (!stack.isEmpty()) {
                        stack.writeToNBT(nbtTagCompound);
                    }
                    bufferTagList.appendTag((NBTBase)nbtTagCompound);
                }
            }
        } else {
            for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack stack = this.inventoryHelper.getStackInSlot(i);
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                if (!stack.isEmpty()) {
                    stack.writeToNBT(nbtTagCompound);
                }
                bufferTagList.appendTag((NBTBase)nbtTagCompound);
            }
        }
        tagCompound.setTag("Items", (NBTBase)bufferTagList);
    }

    private int writeBufferToItemNBT(NBTTagCompound tagCompound) {
        int cnt = 0;
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 3; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
                if (stack.getCount() > 0) {
                    ++cnt;
                }
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("Items", (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.setFilter((String)params.get(PARAM_FILTER));
            this.setViewMode((String)params.get(PARAM_VIEWMODE));
            this.setSortMode((String)params.get(PARAM_SORTMODE));
            this.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            inventory.setInventorySlotContents(i, ItemStack.EMPTY);
        }
        this.markDirty();
    }

    private void cycle() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            this.remoteId = storageTileEntity.cycle(this.remoteId);
            this.getStackInSlot(0).getTagCompound().setInteger("id", this.remoteId);
            this.markDirtyClient();
        }
    }

    private void compact() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            storageTileEntity.compact(this.remoteId);
        } else {
            InventoryHelper.compactStacks((InventoryHelper)this.inventoryHelper, (int)3, (int)this.maxSize);
        }
        this.updateStackCount();
        this.markDirtyClient();
    }

    @Override
    public int getVersion() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return this.version;
            }
            return storageTileEntity.getVersion();
        }
        return this.version;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invHandlerNull == null) {
                this.invHandlerNull = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerNull;
        }
        return (T)super.getCapability(capability, facing);
    }
}

