/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.WorldTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RemoteStorageIdRegistry
extends AbstractWorldData<RemoteStorageIdRegistry> {
    private static final String RFTOOLS_REMOTE_STORAGE = "RFToolsRemoteStorage";
    private int lastId = 0;
    private Map<Integer, GlobalCoordinate> storages = new HashMap<Integer, GlobalCoordinate>();
    private Map<Integer, Long> lastPublishTime = new HashMap<Integer, Long>();

    public RemoteStorageIdRegistry(String name) {
        super(name);
    }

    public void clear() {
        this.storages.clear();
        this.lastPublishTime.clear();
        this.lastId = 0;
    }

    public static RemoteStorageIdRegistry getRegistry(World world) {
        return (RemoteStorageIdRegistry)RemoteStorageIdRegistry.getData((World)world, RemoteStorageIdRegistry.class, (String)RFTOOLS_REMOTE_STORAGE);
    }

    public static RemoteStorageTileEntity getRemoteStorage(World world, int id) {
        if (world.isRemote) {
            return null;
        }
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(world);
        GlobalCoordinate coordinate = registry.getStorage(id);
        if (coordinate == null) {
            return null;
        }
        WorldServer w = DimensionManager.getWorld((int)coordinate.getDimension());
        if (w == null) {
            return null;
        }
        BlockPos c = coordinate.getCoordinate();
        boolean exists = WorldTools.chunkLoaded((World)w, (BlockPos)c);
        if (!exists) {
            return null;
        }
        TileEntity te = w.getTileEntity(c);
        if (te instanceof RemoteStorageTileEntity) {
            RemoteStorageTileEntity remoteStorageTileEntity = (RemoteStorageTileEntity)te;
            int index = remoteStorageTileEntity.findRemoteIndex(id);
            if (index == -1) {
                return null;
            }
            if (remoteStorageTileEntity.isGlobal(index) || world.provider.getDimension() == coordinate.getDimension()) {
                return remoteStorageTileEntity;
            }
            return null;
        }
        return null;
    }

    public void publishStorage(int id, GlobalCoordinate coordinate) {
        long time = System.currentTimeMillis();
        this.storages.put(id, coordinate);
        this.lastPublishTime.put(id, time);
    }

    public GlobalCoordinate getStorage(int id) {
        long time = System.currentTimeMillis();
        if (!this.storages.containsKey(id)) {
            return null;
        }
        long t = this.lastPublishTime.get(id);
        if (time > t + 500L) {
            return null;
        }
        return this.storages.get(id);
    }

    public int getNewId() {
        ++this.lastId;
        return this.lastId;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.lastId = tagCompound.getInteger("lastId");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("lastId", this.lastId);
        return tagCompound;
    }
}

