/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class RemoteStorageItemInventory
implements CraftingGridProvider,
JEIRecipeAcceptor,
IInventory {
    private ItemStackList stacks = ItemStackList.create((int)300);
    private final EntityPlayer entityPlayer;
    private CraftingGrid craftingGrid = new CraftingGrid();
    private ItemStack storageItem = null;

    public RemoteStorageItemInventory(EntityPlayer player, ItemStack storageItem) {
        this.entityPlayer = player;
        this.storageItem = storageItem;
        this.setup();
    }

    public RemoteStorageItemInventory(EntityPlayer player) {
        this.entityPlayer = player;
        this.setup();
    }

    private ItemStack getStorageItem() {
        if (this.storageItem != null) {
            return this.storageItem;
        }
        return this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND);
    }

    private void setup() {
        NBTTagCompound tagCompound = this.getStorageItem().getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.getStorageItem().setTagCompound(tagCompound);
        }
        this.craftingGrid.readFromNBT(tagCompound.getCompoundTag("grid"));
    }

    private RemoteStorageTileEntity getRemoteStorage() {
        int id = this.getStorageID();
        if (id == -1) {
            return null;
        }
        return RemoteStorageIdRegistry.getRemoteStorage(this.entityPlayer.getEntityWorld(), id);
    }

    private int getStorageID() {
        ItemStack heldItem = this.getStorageItem();
        if (heldItem.isEmpty() || heldItem.getTagCompound() == null) {
            return -1;
        }
        return heldItem.getTagCompound().getInteger("id");
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.markDirty();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.markDirty();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayer player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.inventory, 0).add(this, 0);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().setInventorySlotContents(i, stacks.get(i));
        }
        this.markDirty();
    }

    private boolean isServer() {
        return !this.entityPlayer.getEntityWorld().isRemote;
    }

    private ItemStackList getStacks() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStackList.create((int)0);
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStackList.create((int)0);
            }
            return storage.getRemoteStacks(si);
        }
        int maxSize = this.getStorageItem().getTagCompound().getInteger("maxSize");
        if (maxSize != this.stacks.size()) {
            this.stacks = ItemStackList.create((int)maxSize);
        }
        return this.stacks;
    }

    public int getSizeInventory() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return 0;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return 0;
            }
            int maxStacks = storage.getMaxStacks(si);
            this.getStorageItem().getTagCompound().setInteger("maxSize", maxStacks);
            return maxStacks;
        }
        return this.getStorageItem().getTagCompound().getInteger("maxSize");
    }

    public ItemStack getStackInSlot(int index) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStack.EMPTY;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStack.EMPTY;
            }
            return storage.getRemoteSlot(si, index);
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStack.EMPTY;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStack.EMPTY;
            }
            return storage.decrStackSizeRemote(si, index, amount);
        }
        if (index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            this.markDirty();
            if (((ItemStack)this.stacks.get(index)).getCount() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.EMPTY);
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).splitStack(amount);
            if (((ItemStack)this.stacks.get(index)).isEmpty()) {
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            }
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return;
            }
            storage.updateRemoteSlot(si, this.getInventoryStackLimit(), index, stack);
        } else {
            if (index >= this.stacks.size()) {
                return;
            }
            this.stacks.set(index, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
                int amount = this.getInventoryStackLimit();
                if (amount <= 0) {
                    stack.setCount(0);
                } else {
                    stack.setCount(amount);
                }
            }
            this.markDirty();
        }
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        RemoteStorageTileEntity storage = this.getRemoteStorage();
        if (storage != null) {
            storage.markDirty();
        }
        NBTTagCompound tagCompound = this.getStorageItem().getTagCompound();
        tagCompound.setTag("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        ItemStackList s = this.getStacks();
        if (index >= s.size()) {
            return false;
        }
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return false;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return false;
            }
            if (index >= storage.getMaxStacks(si)) {
                return false;
            }
        }
        return true;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setInventorySlotContents(index, ItemStack.EMPTY);
        return stack;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }

    public String getName() {
        return "remote inventory";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return null;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.isUsable(player);
    }

    public boolean isEmpty() {
        return false;
    }
}

