/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storagemonitor.PacketReturnInventoryInfo;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetInventoryInfo
implements IMessage {
    private int id;
    private BlockPos pos;
    private boolean doscan;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
        this.doscan = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        byteBuf.writeInt(this.id);
        byteBuf.writeBoolean(this.doscan);
    }

    public PacketGetInventoryInfo() {
    }

    public PacketGetInventoryInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetInventoryInfo(int worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> this.onMessageServer(ctx.getSender()).ifPresent(p -> this.sendReplyToClient((List<PacketReturnInventoryInfo.InventoryInfo>)p, ctx.getSender())));
        ctx.setPacketHandled(true);
    }

    private void sendReplyToClient(List<PacketReturnInventoryInfo.InventoryInfo> reply, EntityPlayerMP player) {
        PacketReturnInventoryInfo msg = new PacketReturnInventoryInfo(reply);
        RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
    }

    private Optional<List<PacketReturnInventoryInfo.InventoryInfo>> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.getTileEntity(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scannerTileEntity.findInventories() : scannerTileEntity.getAllInventories();
            List invs = inventories.map(arg_0 -> PacketGetInventoryInfo.lambda$onMessageServer$2((World)world, scannerTileEntity, arg_0)).collect(Collectors.toList());
            return Optional.of(invs);
        }
        return Optional.empty();
    }

    private static PacketReturnInventoryInfo.InventoryInfo toInventoryInfo(World world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        ItemStack stack = ItemStack.EMPTY;
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
            displayName = "[UNLOADED]";
        } else if (world.isAirBlock(pos)) {
            displayName = "[REMOVED]";
        } else {
            ModularStorageTileEntity storageTileEntity;
            ItemStack storageModule;
            IBlockState state = world.getBlockState(pos);
            stack = state.getBlock().getItem(world, pos, state);
            displayName = stack.getDisplayName();
            TileEntity storageTe = world.getTileEntity(pos);
            if (storageTe instanceof ModularStorageTileEntity && !(storageModule = (storageTileEntity = (ModularStorageTileEntity)storageTe).getStackInSlot(0)).isEmpty() && storageModule.getTagCompound().hasKey("display")) {
                displayName = storageModule.getDisplayName();
            }
        }
        return new PacketReturnInventoryInfo.InventoryInfo(pos, displayName, te.isRoutable(pos), stack);
    }

    private static /* synthetic */ PacketReturnInventoryInfo.InventoryInfo lambda$onMessageServer$2(World world, StorageScannerTileEntity scannerTileEntity, BlockPos pos) {
        return PacketGetInventoryInfo.toInventoryInfo(world, pos, scannerTileEntity);
    }
}

