/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.GuiMatterTransmitter;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterTransmitterTileEntity
extends GenericEnergyReceiverTileEntity
implements MachineInformation,
ITickable {
    public static final String CMD_ADDPLAYER = "transmitter.addPlayer";
    public static final String CMD_DELPLAYER = "transmitter.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private static final String[] TAGS = new String[]{"dim", "coord", "name"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The dimension this transmitter is dialed too", "The coordinate this transmitter is dialed too", "The name of the destination"};
    private TeleportDestination teleportDestination = null;
    private Integer teleportId = null;
    private boolean once = false;
    private String name = null;
    private boolean privateAccess = false;
    private boolean beamHidden = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int status = 0;
    private String teleportingPlayer = null;
    private int teleportTimer = 0;
    private int cooldownTimer = 0;
    private int totalTicks;
    private int goodTicks;
    private int badTicks;
    private int rfPerTick = 0;
    private int checkReceiverStatusCounter = 20;
    private AxisAlignedBB beamBox = null;
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    public static final Key<Boolean> VALUE_PRIVATE = new Key("private", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_BEAM = new Key("beam", Type.BOOLEAN);

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getName, this::setName), new DefaultValue(VALUE_PRIVATE, this::isPrivateAccess, this::setPrivateAccess), new DefaultValue(VALUE_BEAM, this::isBeamHidden, this::setBeamHidden)};
    }

    public MatterTransmitterTileEntity() {
        super((long)TeleportConfiguration.TRANSMITTER_MAXENERGY.get(), (long)TeleportConfiguration.TRANSMITTER_RECEIVEPERTICK.get());
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean isBeamHidden() {
        return this.beamHidden;
    }

    public void setBeamHidden(boolean b) {
        this.beamHidden = b;
        this.markDirtyClient();
    }

    public boolean isOnce() {
        return this.once;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return "<not dialed>";
        }
        switch (index) {
            case 0: {
                return Integer.toString(destination.getDimension());
            }
            case 1: {
                return destination.getCoordinate().toString();
            }
            case 2: {
                return destination.getName();
            }
        }
        return null;
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public int getStatus() {
        return this.status;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.teleportTimer = tagCompound.getInteger("tpTimer");
        this.cooldownTimer = tagCompound.getInteger("cooldownTimer");
        this.totalTicks = tagCompound.getInteger("totalTicks");
        this.goodTicks = tagCompound.getInteger("goodTicks");
        this.badTicks = tagCompound.getInteger("badTicks");
        this.teleportingPlayer = tagCompound.getString("tpPlayer");
        if (this.teleportingPlayer.isEmpty()) {
            this.teleportingPlayer = null;
        }
        this.status = tagCompound.getInteger("status");
        this.rfPerTick = tagCompound.getInteger("rfPerTick");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.getString("tpName");
        BlockPos c = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        if (c == null) {
            this.teleportDestination = null;
        } else {
            int dim = tagCompound.getInteger("dim");
            this.teleportDestination = new TeleportDestination(c, dim);
        }
        this.teleportId = tagCompound.hasKey("destId") ? Integer.valueOf(tagCompound.getInteger("destId")) : null;
        this.privateAccess = tagCompound.getBoolean("private");
        this.beamHidden = tagCompound.getBoolean("hideBeam");
        this.once = tagCompound.getBoolean("once");
        this.allowedPlayers.clear();
        NBTTagList playerList = tagCompound.getTagList("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.tagCount(); ++i) {
                String player = playerList.getStringTagAt(i);
                this.allowedPlayers.add(player);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("tpTimer", this.teleportTimer);
        tagCompound.setInteger("cooldownTimer", this.cooldownTimer);
        tagCompound.setInteger("totalTicks", this.totalTicks);
        tagCompound.setInteger("goodTicks", this.goodTicks);
        tagCompound.setInteger("badTicks", this.badTicks);
        if (this.teleportingPlayer != null) {
            tagCompound.setString("tpPlayer", this.teleportingPlayer);
        }
        tagCompound.setInteger("status", this.status);
        tagCompound.setInteger("rfPerTick", this.rfPerTick);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        BlockPos c;
        super.writeRestorableToNBT(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.setString("tpName", this.name);
        }
        if (this.teleportDestination != null && (c = this.teleportDestination.getCoordinate()) != null) {
            BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)c);
            tagCompound.setInteger("dim", this.teleportDestination.getDimension());
        }
        if (this.teleportId != null) {
            tagCompound.setInteger("destId", this.teleportId.intValue());
        }
        tagCompound.setBoolean("private", this.privateAccess);
        tagCompound.setBoolean("hideBeam", this.beamHidden);
        tagCompound.setBoolean("once", this.once);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.allowedPlayers) {
            playerTagList.appendTag((NBTBase)new NBTTagString(player));
        }
        tagCompound.setTag("players", (NBTBase)playerTagList);
    }

    public boolean isDialed() {
        return this.teleportId != null || this.teleportDestination != null;
    }

    public Integer getTeleportId() {
        if (this.isDialed() && this.teleportId == null) {
            this.getTeleportDestination();
        }
        return this.teleportId;
    }

    public TeleportDestination getTeleportDestination() {
        if (this.teleportId != null) {
            TeleportDestinations teleportDestinations = TeleportDestinations.getDestinations(this.getWorld());
            GlobalCoordinate gc = teleportDestinations.getCoordinateForId(this.teleportId);
            if (gc == null) {
                return null;
            }
            return teleportDestinations.getDestination(gc.getCoordinate(), gc.getDimension());
        }
        return this.teleportDestination;
    }

    public void setTeleportDestination(TeleportDestination teleportDestination, boolean once) {
        this.teleportDestination = null;
        this.teleportId = null;
        this.once = once;
        if (teleportDestination != null) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.getWorld());
            Integer id = destinations.getIdForCoordinate(new GlobalCoordinate(teleportDestination.getCoordinate(), teleportDestination.getDimension()));
            if (id == null) {
                this.teleportDestination = teleportDestination;
            } else {
                this.teleportId = id;
            }
        }
        this.markDirtyClient();
    }

    private void consumeIdlePower() {
        if (TeleportConfiguration.rfMatterIdleTick.get() > 0 && this.teleportingPlayer == null) {
            if (this.getStoredPower() >= (long)TeleportConfiguration.rfMatterIdleTick.get()) {
                this.consumeEnergy(TeleportConfiguration.rfMatterIdleTick.get());
            } else {
                this.setTeleportDestination(null, false);
            }
        }
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.isDialed()) {
            this.consumeIdlePower();
            --this.checkReceiverStatusCounter;
            if (this.checkReceiverStatusCounter <= 0) {
                this.checkReceiverStatusCounter = 20;
                int newstatus = DialingDeviceTileEntity.isDestinationAnalyzerAvailable(this.getWorld(), this.getPos()) ? this.checkReceiverStatus() : 0;
                if (newstatus != this.status) {
                    this.status = newstatus;
                    this.markDirtyClient();
                }
            }
        }
        if (this.isCoolingDown()) {
            return;
        }
        if (this.teleportingPlayer == null) {
            if (this.isDestinationValid()) {
                this.searchForNearestPlayer();
            }
        } else if (this.teleportDestination == null && this.teleportId == null) {
            EntityPlayer player = this.getWorld().getPlayerEntityByName(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((EntityPlayer)player, (String)"The destination vanished! Aborting.");
            }
            this.clearTeleport(80);
        } else if (this.isPlayerOutsideBeam()) {
            this.clearTeleport(80);
        } else {
            int rf = this.rfPerTick;
            if (this.getStoredPower() < (long)rf) {
                this.handleEnergyShortage();
            } else {
                this.markDirty();
                this.consumeEnergy(rf);
                ++this.goodTicks;
                --this.teleportTimer;
                if (this.teleportTimer <= 0) {
                    this.performTeleport();
                }
            }
        }
    }

    private int checkReceiverStatus() {
        TileEntity tileEntity;
        BlockPos c;
        boolean exists;
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return 1;
        }
        int dimension = destination.getDimension();
        WorldServer w = DimensionManager.getWorld((int)dimension);
        if (w == null) {
            if (TeleportConfiguration.matterTransmitterLoadWorld.get() == -1) {
                return 2;
            }
            w = this.getWorld().getMinecraftServer().getWorld(dimension);
            this.checkReceiverStatusCounter = TeleportConfiguration.matterTransmitterLoadWorld.get();
        }
        if (!(exists = WorldTools.chunkLoaded((World)w, (BlockPos)(c = destination.getCoordinate())))) {
            if (TeleportConfiguration.matterTransmitterLoadChunk.get() == -1) {
                return 2;
            }
            this.checkReceiverStatusCounter = TeleportConfiguration.matterTransmitterLoadChunk.get();
        }
        if (!((tileEntity = w.getTileEntity(c)) instanceof MatterReceiverTileEntity)) {
            return 1;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        int status = matterReceiverTileEntity.checkStatus();
        return status == 0 ? 0 : 1;
    }

    private void clearTeleport(int cooldown) {
        this.markDirty();
        TeleportationTools.applyBadEffectIfNeeded(this.getWorld().getPlayerEntityByName(this.teleportingPlayer), 0, this.badTicks, this.totalTicks, false);
        this.cooldownTimer = cooldown;
        this.teleportingPlayer = null;
    }

    private boolean isDestinationValid() {
        return this.teleportId != null || this.teleportDestination != null && this.teleportDestination.isValid();
    }

    private boolean isCoolingDown() {
        this.markDirty();
        --this.cooldownTimer;
        if (this.cooldownTimer > 0) {
            return true;
        }
        this.cooldownTimer = 0;
        return false;
    }

    private void prepareBeamBox() {
        if (this.beamBox == null) {
            int xCoord = this.getPos().getX();
            int yCoord = this.getPos().getY();
            int zCoord = this.getPos().getZ();
            this.beamBox = new AxisAlignedBB((double)xCoord, (double)(yCoord + 1), (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 3), (double)(zCoord + 1));
        }
    }

    private void searchForNearestPlayer() {
        this.prepareBeamBox();
        List l = this.getWorld().getEntitiesWithinAABB(EntityPlayer.class, this.beamBox);
        Entity nearestPlayer = this.findNearestPlayer(l);
        if (nearestPlayer == null) {
            this.cooldownTimer = 5;
            return;
        }
        AxisAlignedBB playerBB = nearestPlayer.getEntityBoundingBox();
        if (playerBB == null) {
            this.cooldownTimer = 5;
            return;
        }
        if (playerBB.intersects(this.beamBox)) {
            this.startTeleportation(nearestPlayer);
        } else {
            this.cooldownTimer = 5;
        }
    }

    private Entity findNearestPlayer(List<Entity> l) {
        Entity nearestPlayer = null;
        double dmax = Double.MAX_VALUE;
        for (Entity entity : l) {
            double d1;
            EntityPlayer entityPlayer;
            if (!(entity instanceof EntityPlayer) || (entityPlayer = (EntityPlayer)entity).isRiding() || entityPlayer.isBeingRidden() || entityPlayer.getName() == null || this.isPrivateAccess() && !this.allowedPlayers.contains(entityPlayer.getName()) || !((d1 = entity.getDistanceSq((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.5, (double)this.getPos().getZ() + 0.5)) <= dmax)) continue;
            nearestPlayer = entity;
            dmax = d1;
        }
        return nearestPlayer;
    }

    private void performTeleport() {
        boolean boostNeeded;
        EntityPlayer player;
        boolean boosted;
        if (!this.isDestinationStillValid()) {
            EntityPlayer player2 = this.getWorld().getPlayerEntityByName(this.teleportingPlayer);
            if (player2 != null) {
                TeleportationTools.applyBadEffectIfNeeded(player2, 10, this.badTicks, this.totalTicks, false);
                Logging.warn((EntityPlayer)player2, (String)"Missing destination!");
            }
            this.clearTeleport(200);
            return;
        }
        TeleportDestination dest = this.getTeleportDestination();
        if (this.once) {
            this.setTeleportDestination(null, false);
        }
        if ((boosted = DialingDeviceTileEntity.isMatterBoosterAvailable(this.getWorld(), this.getPos())) && this.getStoredPower() < (long)TeleportConfiguration.rfBoostedTeleport.get()) {
            boosted = false;
        }
        if ((player = this.getWorld().getPlayerEntityByName(this.teleportingPlayer)) != null && (boostNeeded = TeleportationTools.performTeleport(player, dest, this.badTicks, this.totalTicks, boosted))) {
            this.consumeEnergy(TeleportConfiguration.rfBoostedTeleport.get());
        }
        this.teleportingPlayer = null;
    }

    private boolean isDestinationStillValid() {
        TeleportDestination dest = this.getTeleportDestination();
        return TeleportDestinations.getDestinations(this.getWorld()).isDestinationValid(dest);
    }

    private void handleEnergyShortage() {
        this.markDirty();
        ++this.badTicks;
        if (TeleportationTools.mustInterrupt(this.badTicks, this.totalTicks)) {
            EntityPlayer player = this.getWorld().getPlayerEntityByName(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((EntityPlayer)player, (String)"Power failure during transit!");
            }
            this.clearTeleport(200);
        }
    }

    private boolean isPlayerOutsideBeam() {
        EntityPlayer player = this.getWorld().getPlayerEntityByName(this.teleportingPlayer);
        if (player == null) {
            return true;
        }
        AxisAlignedBB playerBB = player.getEntityBoundingBox();
        if (playerBB == null) {
            return true;
        }
        this.prepareBeamBox();
        if (!playerBB.intersects(this.beamBox)) {
            Logging.message((EntityPlayer)player, (String)"Teleportation was interrupted!");
            return true;
        }
        return false;
    }

    public void startTeleportation(Entity entity) {
        if (this.cooldownTimer > 0) {
            return;
        }
        if (this.teleportingPlayer != null) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.isRiding() || player.isBeingRidden()) {
            this.cooldownTimer = 80;
            return;
        }
        TeleportDestination dest = this.teleportDestination;
        if (this.teleportId != null) {
            dest = this.getTeleportDestination();
        }
        if (dest != null && dest.isValid()) {
            int dstId;
            int cost = TeleportationTools.calculateRFCost(this.getWorld(), this.getPos(), dest);
            cost = (int)((float)cost * (4.0f - this.getInfusedFactor()) / 4.0f);
            if (this.getStoredPower() < (long)cost) {
                Logging.warn((EntityPlayer)player, (String)"Not enough power to start the teleport!");
                this.cooldownTimer = 80;
                return;
            }
            int srcId = this.getWorld().provider.getDimension();
            if (!TeleportationTools.checkValidTeleport(player, srcId, dstId = dest.getDimension())) {
                this.cooldownTimer = 80;
                return;
            }
            Logging.message((EntityPlayer)player, (String)"Start teleportation...");
            this.teleportingPlayer = player.getName();
            this.teleportTimer = TeleportationTools.calculateTime(this.getWorld(), this.getPos(), dest);
            this.teleportTimer = (int)((float)this.teleportTimer * (1.2f - this.getInfusedFactor()) / 1.2f);
            int rf = TeleportConfiguration.rfTeleportPerTick.get();
            rf = (int)((float)rf * (4.0f - this.getInfusedFactor()) / 4.0f);
            int totalRfUsed = cost + rf * (this.teleportTimer + 1);
            this.rfPerTick = totalRfUsed / (this.teleportTimer + 1);
            this.totalTicks = this.teleportTimer;
            this.goodTicks = 0;
            this.badTicks = 0;
        } else {
            Logging.warn((EntityPlayer)player, (String)"Something is wrong with the destination!");
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getAllowedPlayers());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterTransmitter.storeAllowedPlayersForClient(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos(), this.getPos().add(1, 4, 1));
    }
}

