/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.wheelsupport;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.WheelActionElement;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.compat.wheelsupport.FindBlockClient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class FindBlockAction
implements IWheelAction {
    public static final String ACTION_FINDBLOCK = "rftools.findblock";

    public String getId() {
        return ACTION_FINDBLOCK;
    }

    public WheelActionElement createElement() {
        return new WheelActionElement(ACTION_FINDBLOCK).description("Find the block you look at out of storage", null).texture("rftools:textures/gui/wheel_actions.png", 96, 0, 96, 32, 128, 128);
    }

    public boolean performClient(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        return FindBlockClient.pickBlockClient(world, pos, player);
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && (!stack1.getHasSubtypes() || stack1.getMetadata() == stack2.getMetadata()) && ItemStack.areItemStackTagsEqual((ItemStack)stack1, (ItemStack)stack2);
    }

    public void performServer(EntityPlayer player, World world, @Nullable BlockPos pos, boolean extended) {
        if (pos != null) {
            List<ItemStack> inventory = Collections.unmodifiableList(player.inventory.mainInventory);
            IBlockState state = world.getBlockState(pos);
            ItemStack result = state.getBlock().getItem(world, pos, state);
            if (result == null || result.isEmpty()) {
                return;
            }
            ItemStack storage = ItemStack.EMPTY;
            for (ItemStack stack : inventory) {
                if (stack.isEmpty() || stack.getItem() != ModularStorageSetup.storageModuleTabletItem) continue;
                storage = stack;
                break;
            }
            if (storage.isEmpty()) {
                player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "No storage tablet in inventory!"), false);
                return;
            }
            NBTTagCompound tagCompound = storage.getTagCompound();
            if (tagCompound == null || !tagCompound.hasKey("childDamage")) {
                player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "No storage module in tablet!"), false);
                return;
            }
            int firstEmptyStack = player.inventory.getFirstEmptyStack();
            if (firstEmptyStack < 0) {
                player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "No room in inventory for block!"), false);
                return;
            }
            int moduleDamage = tagCompound.getInteger("childDamage");
            ItemStack extracted = ItemStack.EMPTY;
            if (moduleDamage == 666) {
                if (tagCompound.hasKey("monitorx")) {
                    int monitordim = tagCompound.getInteger("monitordim");
                    int monitorx = tagCompound.getInteger("monitorx");
                    int monitory = tagCompound.getInteger("monitory");
                    int monitorz = tagCompound.getInteger("monitorz");
                    BlockPos mpos = new BlockPos(monitorx, monitory, monitorz);
                    WorldServer w = DimensionManager.getWorld((int)monitordim);
                    if (w == null || !WorldTools.chunkLoaded((World)w, (BlockPos)mpos)) {
                        player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage scanner is out of range!"), false);
                    } else {
                        StorageScannerTileEntity scanner;
                        TileEntity te = w.getTileEntity(mpos);
                        if (te instanceof StorageScannerTileEntity && (extracted = (scanner = (StorageScannerTileEntity)te).requestItem(result, result.getMaxStackSize(), true, false)).isEmpty()) {
                            extracted = scanner.requestItem(result, result.getMaxStackSize(), true, true);
                        }
                    }
                } else {
                    player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage module is not linked to a storage scanner!"), false);
                }
            } else if (moduleDamage == 6) {
                if (!tagCompound.hasKey("id")) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This remote storage module is not linked!"));
                } else {
                    RemoteStorageItemInventory storageInv = new RemoteStorageItemInventory(player, storage);
                    for (int i = 0; i < storageInv.getSizeInventory(); ++i) {
                        ItemStack s = storageInv.getStackInSlot(i);
                        if (s.isEmpty() || !this.stackEqualExact(result, s)) continue;
                        extracted = s;
                        storageInv.setInventorySlotContents(i, ItemStack.EMPTY);
                        break;
                    }
                }
            } else {
                ModularStorageItemInventory storageInv = new ModularStorageItemInventory(player, storage);
                for (int i = 0; i < storageInv.getSizeInventory(); ++i) {
                    ItemStack s = storageInv.getStackInSlot(i);
                    if (s.isEmpty() || !this.stackEqualExact(result, s)) continue;
                    extracted = s;
                    storageInv.setInventorySlotContents(i, ItemStack.EMPTY);
                    break;
                }
            }
            if (!extracted.isEmpty()) {
                int currentItem = player.inventory.currentItem;
                if (currentItem == firstEmptyStack) {
                    player.inventory.setInventorySlotContents(currentItem, extracted);
                } else {
                    player.inventory.setInventorySlotContents(firstEmptyStack, inventory.get(currentItem));
                    player.inventory.setInventorySlotContents(currentItem, extracted);
                }
                player.openContainer.detectAndSendChanges();
            }
        }
    }
}

