/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.crafting;

import com.google.gson.JsonObject;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.rftools.items.screenmodules.StorageControlModuleItem;
import mcjty.rftools.items.storage.StorageModuleTabletItem;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ContainerAndItemRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getRecipeWidth();
        primer.height = recipe.getRecipeHeight();
        primer.mirrored = JsonUtils.getBoolean((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.getIngredients();
        return new ContainerAndItemRecipe(new ResourceLocation("rftools", "container_and_item"), recipe.getRecipeOutput(), primer);
    }

    public static class ContainerAndItemRecipe
    extends ShapedOreRecipe {
        public ContainerAndItemRecipe(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
            super(group, result, primer);
        }

        public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
            ItemStack result = super.getCraftingResult(inventoryCrafting);
            if (!result.isEmpty()) {
                Integer damage;
                ItemStack itemstackForNBT = ItemStack.EMPTY;
                ItemStack tabletItem = ItemStack.EMPTY;
                for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
                    ItemStack stack = inventoryCrafting.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    if (stack.getItem() instanceof StorageModuleTabletItem) {
                        tabletItem = stack;
                        continue;
                    }
                    if (stack.getItem() instanceof INBTPreservingIngredient) {
                        itemstackForNBT = stack;
                        continue;
                    }
                    if (!(Block.getBlockFromItem((Item)stack.getItem()) instanceof INBTPreservingIngredient)) continue;
                    itemstackForNBT = stack;
                }
                NBTTagCompound tagCompound = null;
                if (!itemstackForNBT.isEmpty() && (tagCompound = itemstackForNBT.getTagCompound()) != null) {
                    tagCompound = tagCompound.copy();
                }
                if (tagCompound != null) {
                    result.setTagCompound(tagCompound);
                }
                NBTTagCompound tagCompoundTablet = null;
                if (!tabletItem.isEmpty()) {
                    tagCompoundTablet = tabletItem.getTagCompound();
                }
                if (tagCompoundTablet != null) {
                    ContainerAndItemRecipe.getCompound(result).setInteger("Energy", tagCompoundTablet.getInteger("Energy"));
                    if (tagCompoundTablet.hasKey("grid")) {
                        ContainerAndItemRecipe.getCompound(result).setTag("grid", tagCompoundTablet.getTag("grid"));
                    }
                }
                if ((damage = itemstackForNBT.getItem() instanceof StorageControlModuleItem ? Integer.valueOf(666) : Integer.valueOf(itemstackForNBT.getMetadata())) != null) {
                    ContainerAndItemRecipe.getCompound(result).setInteger("childDamage", damage.intValue());
                }
            }
            return result;
        }

        private static NBTTagCompound getCompound(ItemStack stack) {
            if (stack.getTagCompound() == null) {
                stack.setTagCompound(new NBTTagCompound());
            }
            return stack.getTagCompound();
        }
    }
}

