/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.builder;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.PacketUpdateNBTItemInventoryShape;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.ShapeCardType;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.PacketUpdateNBTShapeCard;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiShapeCard
extends GuiScreen
implements IShapeParentGui {
    protected int xSize = 360;
    protected int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private boolean isQuarryCard;
    private ChoiceLabel shapeLabel;
    private ChoiceLabel solidLabel;
    private TextField dimX;
    private TextField dimY;
    private TextField dimZ;
    private TextField offsetX;
    private TextField offsetY;
    private TextField offsetZ;
    private Window window;
    private Label blocksLabel;
    private Panel voidPanel;
    private ToggleButton stone;
    private ToggleButton cobble;
    private ToggleButton dirt;
    private ToggleButton gravel;
    private ToggleButton sand;
    private ToggleButton netherrack;
    private ToggleButton endstone;
    private ToggleButton oredict;
    public final boolean fromTE;
    public static BlockPos fromTEPos = null;
    public static int fromTEStackSlot = 0;
    public static GuiScreen returnGui = null;
    private ShapeID shapeID = null;
    private ShapeRenderer shapeRenderer = null;
    private static int updateCounter = 20;

    public GuiShapeCard(boolean fromTE) {
        this.fromTE = fromTE;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeID == null) {
            this.shapeID = this.getShapeID();
        } else if (!this.shapeID.equals(this.getShapeID())) {
            this.shapeID = this.getShapeID();
            this.shapeRenderer = null;
        }
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.shapeID);
            this.shapeRenderer.initView(this.getPreviewLeft(), this.guiTop);
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        ItemStack stackToEdit = this.getStackToEdit();
        return new ShapeID(0, null, ShapeCardItem.getScanId(stackToEdit), false, ShapeCardItem.isSolid(stackToEdit));
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private ItemStack getStackToEdit() {
        if (this.fromTE) {
            TileEntity te = this.mc.world.getTileEntity(fromTEPos);
            if (te instanceof IInventory) {
                return ((IInventory)te).getStackInSlot(fromTEStackSlot);
            }
            return ItemStack.EMPTY;
        }
        return this.mc.player.getHeldItem(EnumHand.MAIN_HAND);
    }

    @Override
    public int getPreviewLeft() {
        return this.guiLeft + 104;
    }

    @Override
    public int getPreviewTop() {
        return this.guiTop - 5 + (this.isQuarryCard ? 0 : 10);
    }

    public void initGui() {
        Panel toplevel;
        super.initGui();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        ItemStack heldItem = this.getStackToEdit();
        if (heldItem.isEmpty()) {
            return;
        }
        this.isQuarryCard = ShapeCardType.fromDamage(heldItem.getItemDamage()).isQuarry();
        if (this.isQuarryCard) {
            this.ySize = 188;
        }
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.guiTop);
        this.shapeLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this).setDesiredWidth(100)).setDesiredHeight(16)).addChoices(new String[]{Shape.SHAPE_BOX.getDescription(), Shape.SHAPE_TOPDOME.getDescription(), Shape.SHAPE_BOTTOMDOME.getDescription(), Shape.SHAPE_SPHERE.getDescription(), Shape.SHAPE_CYLINDER.getDescription(), Shape.SHAPE_CAPPEDCYLINDER.getDescription(), Shape.SHAPE_PRISM.getDescription(), Shape.SHAPE_TORUS.getDescription(), Shape.SHAPE_CONE.getDescription(), Shape.SHAPE_HEART.getDescription(), Shape.SHAPE_COMPOSITION.getDescription(), Shape.SHAPE_SCAN.getDescription()}).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.solidLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this).setDesiredWidth(50)).setDesiredHeight(16)).addChoices(new String[]{"Hollow", "Solid"}).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        Panel shapePanel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)this.shapeLabel)).addChild((Widget)this.solidLabel);
        Shape shape = ShapeCardItem.getShape(heldItem);
        this.shapeLabel.setChoice(shape.getDescription());
        boolean solid = ShapeCardItem.isSolid(heldItem);
        this.solidLabel.setChoice(solid ? "Solid" : "Hollow");
        this.blocksLabel = (Label)((Label)new Label(this.mc, (Gui)this).setText("# ")).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.blocksLabel.setDesiredWidth(100)).setDesiredHeight(16);
        Panel modePanel = (Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new VerticalLayout()).setDesiredWidth(170)).addChild((Widget)shapePanel)).addChild((Widget)this.blocksLabel);
        BlockPos dim = ShapeCardItem.getDimension(heldItem);
        BlockPos offset = ShapeCardItem.getOffset(heldItem);
        this.dimX = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> {
            if (this.isTorus()) {
                this.dimZ.setText(newText);
            }
            this.updateSettings();
        }).setText(String.valueOf(dim.getX()));
        this.dimY = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(dim.getY()));
        this.dimZ = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(dim.getZ()));
        Panel dimPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)((Label)((Label)new Label(this.mc, (Gui)this).setText("Dim:")).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setDesiredWidth(40))).setDesiredHeight(18)).addChild((Widget)this.dimX)).addChild((Widget)this.dimY)).addChild((Widget)this.dimZ);
        this.offsetX = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.getX()));
        this.offsetY = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.getY()));
        this.offsetZ = new TextField(this.mc, (Gui)this).addTextEvent((parent, newText) -> this.updateSettings()).setText(String.valueOf(offset.getZ()));
        Panel offsetPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)((Label)((Label)new Label(this.mc, (Gui)this).setText("Offset:")).setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)).setDesiredWidth(40))).setDesiredHeight(18)).addChild((Widget)this.offsetX)).addChild((Widget)this.offsetY)).addChild((Widget)this.offsetZ);
        Panel settingsPanel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(1)).setHorizontalMargin(0)).addChild((Widget)dimPanel)).addChild((Widget)offsetPanel);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        Panel modeSettingsPanel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new VerticalLayout().setHorizontalMargin(0)).addChild((Widget)modePanel)).addChild((Widget)settingsPanel);
        modeSettingsPanel.setLayoutHint(0, 0, 180, 160);
        if (this.isQuarryCard) {
            this.setupVoidPanel(heldItem);
            toplevel = (Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel)).addChild((Widget)this.voidPanel);
        } else {
            toplevel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel);
        }
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private void setupVoidPanel(ItemStack heldItem) {
        this.voidPanel = (Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(26)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        this.voidPanel.setLayoutHint(5, 155, 350, 26);
        Label label = (Label)new Label(this.mc, (Gui)this).setText("Void:");
        this.stone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void stone"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.cobble = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void cobble"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.dirt = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void dirt"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.gravel = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void gravel"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.sand = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void sand"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.netherrack = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void netherrack"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.endstone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void end stone"})).addButtonEvent(widget -> this.updateVoidSettings());
        this.oredict = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Enable ore dictionary matching"})).setText("Oredict")).setCheckMarker(true).addButtonEvent(widget -> this.updateVoidSettings());
        this.stone.setPressed(ShapeCardItem.isVoiding(heldItem, "stone"));
        this.cobble.setPressed(ShapeCardItem.isVoiding(heldItem, "cobble"));
        this.dirt.setPressed(ShapeCardItem.isVoiding(heldItem, "dirt"));
        this.gravel.setPressed(ShapeCardItem.isVoiding(heldItem, "gravel"));
        this.sand.setPressed(ShapeCardItem.isVoiding(heldItem, "sand"));
        this.netherrack.setPressed(ShapeCardItem.isVoiding(heldItem, "netherrack"));
        this.endstone.setPressed(ShapeCardItem.isVoiding(heldItem, "endstone"));
        this.oredict.setPressed(ShapeCardItem.isOreDictionary(heldItem));
        this.voidPanel.addChildren(new Widget[]{label, this.stone, this.cobble, this.dirt, this.gravel, this.sand, this.netherrack, this.endstone, this.oredict});
    }

    private boolean isTorus() {
        Shape shape = this.getCurrentShape();
        return Shape.SHAPE_TORUS.equals((Object)shape);
    }

    private Shape getCurrentShape() {
        return Shape.getShape(this.shapeLabel.getCurrentChoice());
    }

    private boolean isSolid() {
        return "Solid".equals(this.solidLabel.getCurrentChoice());
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateSettings() {
        int dx = GuiShapeCard.parseInt(this.dimX.getText());
        int dy = GuiShapeCard.parseInt(this.dimY.getText());
        int dz = GuiShapeCard.parseInt(this.dimZ.getText());
        int max = Math.max(ScannerConfiguration.maxScannerDimension.get(), BuilderConfiguration.maxBuilderDimension.get());
        if (dx < 0) {
            dx = 0;
        } else if (dx > max) {
            dx = max;
        }
        this.dimX.setText(Integer.toString(dx));
        if (dz < 0) {
            dz = 0;
        } else if (dz > max) {
            dz = max;
        }
        this.dimZ.setText(Integer.toString(dz));
        if (dy < 0) {
            dy = 0;
        } else if (dy > 256) {
            dy = 256;
        }
        this.dimY.setText(Integer.toString(dy));
        if (this.isTorus()) {
            this.dimZ.setText(this.dimX.getText());
        }
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.isEmpty()) {
                NBTTagCompound tag = stack.getTagCompound();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                ShapeCardItem.setShape(stack, this.getCurrentShape(), this.isSolid());
                ShapeCardItem.setDimension(stack, dx, dy, dz);
                ShapeCardItem.setOffset(stack, GuiShapeCard.parseInt(this.offsetX.getText()), GuiShapeCard.parseInt(this.offsetY.getText()), GuiShapeCard.parseInt(this.offsetZ.getText()));
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTShapeCard(TypedMap.builder().put(new Key("shapenew", Type.STRING), (Object)this.getCurrentShape().getDescription()).put(new Key("solid", Type.BOOLEAN), (Object)this.isSolid()).put(new Key("dimX", Type.INTEGER), (Object)dx).put(new Key("dimY", Type.INTEGER), (Object)dy).put(new Key("dimZ", Type.INTEGER), (Object)dz).put(new Key("offsetX", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetX.getText())).put(new Key("offsetY", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetY.getText())).put(new Key("offsetZ", Type.INTEGER), (Object)GuiShapeCard.parseInt(this.offsetZ.getText())).build()));
        }
    }

    private void updateVoidSettings() {
        if (this.fromTE) {
            ItemStack stack = this.getStackToEdit();
            if (!stack.isEmpty()) {
                NBTTagCompound tag = stack.getTagCompound();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.setBoolean("voidstone", this.stone.isPressed());
                tag.setBoolean("voidcobble", this.cobble.isPressed());
                tag.setBoolean("voiddirt", this.dirt.isPressed());
                tag.setBoolean("voidgravel", this.gravel.isPressed());
                tag.setBoolean("voidsand", this.sand.isPressed());
                tag.setBoolean("voidnetherrack", this.netherrack.isPressed());
                tag.setBoolean("voidendstone", this.endstone.isPressed());
                tag.setBoolean("oredict", this.oredict.isPressed());
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemInventoryShape(fromTEPos, fromTEStackSlot, tag));
            }
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTShapeCard(TypedMap.builder().put(new Key("voidstone", Type.BOOLEAN), (Object)this.stone.isPressed()).put(new Key("voidcobble", Type.BOOLEAN), (Object)this.cobble.isPressed()).put(new Key("voiddirt", Type.BOOLEAN), (Object)this.dirt.isPressed()).put(new Key("voidgravel", Type.BOOLEAN), (Object)this.gravel.isPressed()).put(new Key("voidsand", Type.BOOLEAN), (Object)this.sand.isPressed()).put(new Key("voidnetherrack", Type.BOOLEAN), (Object)this.netherrack.isPressed()).put(new Key("voidendstone", Type.BOOLEAN), (Object)this.endstone.isPressed()).put(new Key("oredict", Type.BOOLEAN), (Object)this.oredict.isPressed()).build()));
        }
    }

    protected void mouseClicked(int x, int y, int button) throws IOException {
        super.mouseClicked(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.window.handleMouseInput();
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.guiLeft, y -= this.guiTop);
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.window.mouseMovedOrUp(mouseX, mouseY, state);
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void drawScreen(int xSize_lo, int ySize_lo, float par3) {
        List tooltips;
        ItemStack stack;
        this.getShapeRenderer().handleMouseWheel();
        super.drawScreen(xSize_lo, ySize_lo, par3);
        this.dimZ.setEnabled(!this.isTorus());
        if (--updateCounter <= 0) {
            updateCounter = 10;
            int count = this.getShapeRenderer().getCount();
            if (count >= 50000000) {
                this.blocksLabel.setText("#Blocks: ++" + count);
            } else {
                this.blocksLabel.setText("#Blocks: " + count);
            }
        }
        this.window.draw();
        if (this.isQuarryCard) {
            int x = (int)(this.window.getToplevel().getBounds().getX() + this.voidPanel.getBounds().getX()) + 1;
            int y = (int)(this.window.getToplevel().getBounds().getY() + this.voidPanel.getBounds().getY() + this.stone.getBounds().getY()) + 1;
            this.renderVoidBlock(x, y, this.stone, Blocks.STONE);
            this.renderVoidBlock(x, y, this.cobble, Blocks.COBBLESTONE);
            this.renderVoidBlock(x, y, this.dirt, Blocks.DIRT);
            this.renderVoidBlock(x, y, this.gravel, Blocks.GRAVEL);
            this.renderVoidBlock(x, y, this.sand, (Block)Blocks.SAND);
            this.renderVoidBlock(x, y, this.netherrack, Blocks.NETHERRACK);
            this.renderVoidBlock(x, y, this.endstone, Blocks.END_STONE);
        }
        if (!(stack = this.getStackToEdit()).isEmpty()) {
            this.getShapeRenderer().renderShape(this, stack, this.guiLeft, this.guiTop, true, true, true, false);
        }
        if ((tooltips = this.window.getTooltips()) != null) {
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.mc.fontRenderer);
        }
    }

    private void renderVoidBlock(int x, int y, ToggleButton button, Block block) {
        RenderHelper.renderObject((Minecraft)Minecraft.getMinecraft(), (int)(x += (int)button.getBounds().getX()), (int)y, (Object)new ItemStack(block), (boolean)button.isPressed());
        if (button.isPressed()) {
            GuiShapeCard.drawLine(x - 1, y - 1, x + 18, y + 18, -65536);
            GuiShapeCard.drawLine(x + 18, y - 1, x - 1, y + 18, -65536);
        }
    }

    private static void drawLine(int x1, int y1, int x2, int y2, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(1, DefaultVertexFormats.POSITION);
        GlStateManager.enableBlend();
        GlStateManager.disableTexture2D();
        GlStateManager.disableDepth();
        GL11.glLineWidth((float)2.0f);
        GlStateManager.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.color((float)f, (float)f1, (float)f2, (float)f3);
        buffer.pos((double)x1, (double)y1, 0.0).endVertex();
        buffer.pos((double)x2, (double)y2, 0.0).endVertex();
        tessellator.draw();
        GlStateManager.enableTexture2D();
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
    }
}

