/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.items.modifier.ModifierItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class ModifierInventory
implements IInventory {
    private final EntityPlayer entityPlayer;

    public ModifierInventory(EntityPlayer player) {
        this.entityPlayer = player;
        NBTTagCompound tagCompound = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).setTagCompound(tagCompound);
        }
    }

    public int getSizeInventory() {
        return 2;
    }

    public ItemStack getStackInSlot(int index) {
        NBTTagCompound tagCompound = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).getTagCompound();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        return (ItemStack)stacks.get(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        NBTTagCompound tagCompound = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).getTagCompound();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        if (index >= stacks.size()) {
            return ItemStack.EMPTY;
        }
        if (!((ItemStack)stacks.get(index)).isEmpty()) {
            if (((ItemStack)stacks.get(index)).getCount() <= amount) {
                ItemStack old = (ItemStack)stacks.get(index);
                stacks.set(index, (Object)ItemStack.EMPTY);
                ModifierInventory.convertItemsToNBT(tagCompound, stacks);
                this.markDirty();
                return old;
            }
            ItemStack its = ((ItemStack)stacks.get(index)).splitStack(amount);
            if (((ItemStack)stacks.get(index)).isEmpty()) {
                stacks.set(index, (Object)ItemStack.EMPTY);
                ModifierInventory.convertItemsToNBT(tagCompound, stacks);
            }
            this.markDirty();
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void markDirty() {
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        NBTTagCompound tagCompound = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).getTagCompound();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        if (index >= stacks.size()) {
            return;
        }
        stacks.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
        ModifierInventory.convertItemsToNBT(tagCompound, stacks);
        this.markDirty();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public static void convertItemsToNBT(NBTTagCompound tagCompound, ItemStackList stacks) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("Items", (NBTBase)bufferTagList);
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return true;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setInventorySlotContents(index, ItemStack.EMPTY);
        return stack;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }

    public String getName() {
        return "modifier";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return null;
    }
}

