/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.items.netmonitor.PacketConnectedBlocksReady;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.varia.BlockInfo;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetConnectedBlocks
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetConnectedBlocks() {
    }

    public PacketGetConnectedBlocks(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetConnectedBlocks(BlockPos pos) {
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            Map<BlockPos, BlockInfo> connectedBlocks = new HashMap<BlockPos, BlockInfo>();
            this.findConnectedBlocks(connectedBlocks, player.getEntityWorld(), this.pos);
            if (connectedBlocks.size() > NetworkMonitorConfiguration.maximumBlocks.get()) {
                connectedBlocks = this.compactConnectedBlocks(connectedBlocks, this.pos, NetworkMonitorConfiguration.maximumBlocks.get());
            }
            int minx = 300000000;
            int miny = 300000000;
            int minz = 300000000;
            for (BlockPos coordinate : connectedBlocks.keySet()) {
                minx = Math.min(minx, coordinate.getX());
                miny = Math.min(miny, coordinate.getY());
                minz = Math.min(minz, coordinate.getZ());
            }
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketConnectedBlocksReady(connectedBlocks, minx, miny, minz), ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }

    private Map<BlockPos, BlockInfo> compactConnectedBlocks(Map<BlockPos, BlockInfo> old, BlockPos pos, int max) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(old.keySet());
        Collections.sort(list, Comparator.comparingInt(o1 -> (o1.getX() - pos.getX()) * (o1.getX() - pos.getX()) + (o1.getY() - pos.getY()) * (o1.getY() - pos.getY()) + (o1.getZ() - pos.getZ()) * (o1.getZ() - pos.getZ())));
        HashMap<BlockPos, BlockInfo> connectedBlocks = new HashMap<BlockPos, BlockInfo>();
        for (BlockPos coordinate : list) {
            connectedBlocks.put(coordinate, old.get(coordinate));
            if (--max > 0) continue;
            break;
        }
        return connectedBlocks;
    }

    private void findConnectedBlocks(Map<BlockPos, BlockInfo> connectedBlocks, World world, BlockPos pos) {
        if (pos.getY() < 0 || pos.getY() >= world.getHeight()) {
            return;
        }
        if (connectedBlocks.containsKey(pos)) {
            return;
        }
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity != null && EnergyTools.isEnergyTE((TileEntity)tileEntity, null)) {
            connectedBlocks.put(pos, new BlockInfo(tileEntity, null, pos));
            this.findConnectedBlocks(connectedBlocks, world, pos.up());
            this.findConnectedBlocks(connectedBlocks, world, pos.down());
            this.findConnectedBlocks(connectedBlocks, world, pos.east());
            this.findConnectedBlocks(connectedBlocks, world, pos.west());
            this.findConnectedBlocks(connectedBlocks, world, pos.south());
            this.findConnectedBlocks(connectedBlocks, world, pos.north());
        }
    }
}

