/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.items.storage.StorageFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class StorageFilterInventory
implements IInventory {
    private ItemStackList stacks = ItemStackList.create((int)30);
    private final EntityPlayer entityPlayer;

    public StorageFilterInventory(EntityPlayer player) {
        this.entityPlayer = player;
        NBTTagCompound tagCompound = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND).setTagCompound(tagCompound);
        }
        NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
        for (int i = 0; i < bufferTagList.tagCount(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    public int getSizeInventory() {
        return 30;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            if (((ItemStack)this.stacks.get(index)).getCount() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.EMPTY);
                this.markDirty();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).splitStack(amount);
            if (((ItemStack)this.stacks.get(index)).isEmpty()) {
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            }
            this.markDirty();
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (StorageFilterContainer.factory.isGhostSlot(index)) {
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.copy();
                if (index < 9) {
                    stack1.setCount(1);
                }
                this.stacks.set(index, (Object)stack1);
            } else {
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            }
        } else {
            this.stacks.set(index, (Object)stack);
            if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
                int amount = this.getInventoryStackLimit();
                if (amount <= 0) {
                    stack.setCount(0);
                } else {
                    stack.setCount(amount);
                }
            }
        }
        this.markDirty();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        ItemStack heldItem = this.entityPlayer.getHeldItem(EnumHand.MAIN_HAND);
        if (!heldItem.isEmpty()) {
            NBTTagCompound tagCompound = heldItem.getTagCompound();
            StorageFilterInventory.convertItemsToNBT(tagCompound, this.stacks);
        }
    }

    public static void convertItemsToNBT(NBTTagCompound tagCompound, ItemStackList stacks) {
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("Items", (NBTBase)bufferTagList);
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public ItemStack removeStackFromSlot(int index) {
        ItemStack stack = this.getStackInSlot(index);
        this.setInventorySlotContents(index, ItemStack.EMPTY);
        return stack;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }

    public String getName() {
        return "storage filter";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return null;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.isUsable(player);
    }

    public boolean isEmpty() {
        return false;
    }
}

