/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.network.PacketPlayersReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetPlayers
implements IMessage {
    protected BlockPos pos;
    protected String command;
    protected TypedMap params;
    private String clientcmd;

    public PacketGetPlayers(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        this.params = TypedMapTools.readArguments((ByteBuf)buf);
        this.clientcmd = NetworkTools.readString((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.params);
        NetworkTools.writeString((ByteBuf)buf, (String)this.clientcmd);
    }

    public PacketGetPlayers() {
    }

    public PacketGetPlayers(BlockPos pos, String cmd, String clientcmd) {
        this.pos = pos;
        this.command = cmd;
        this.params = TypedMap.EMPTY;
        this.clientcmd = clientcmd;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().getEntityWorld().getTileEntity(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList(this.command, this.params, Type.STRING);
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketPlayersReady(this.pos, this.clientcmd, list), ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

