/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.blocks.shaper.ComposerTileEntity;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSendComposerData
implements IMessage {
    private BlockPos pos;
    private ShapeModifier[] modifiers;

    public void fromBytes(ByteBuf buf) {
        int s = buf.readInt();
        this.modifiers = new ShapeModifier[s];
        for (int i = 0; i < s; ++i) {
            String code = NetworkTools.readString((ByteBuf)buf);
            ShapeOperation op = ShapeOperation.getByName(code);
            boolean flip = buf.readBoolean();
            code = NetworkTools.readString((ByteBuf)buf);
            ShapeRotation rot = ShapeRotation.getByName(code);
            this.modifiers[i] = new ShapeModifier(op, flip, rot);
        }
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.modifiers.length);
        for (ShapeModifier modifier : this.modifiers) {
            NetworkTools.writeString((ByteBuf)buf, (String)modifier.getOperation().getCode());
            buf.writeBoolean(modifier.isFlipY());
            NetworkTools.writeString((ByteBuf)buf, (String)modifier.getRotation().getCode());
        }
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketSendComposerData() {
    }

    public PacketSendComposerData(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSendComposerData(BlockPos pos, ShapeModifier[] modifiers) {
        this.pos = pos;
        this.modifiers = modifiers;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().getEntityWorld().getTileEntity(this.pos);
            if (te instanceof ComposerTileEntity) {
                ((ComposerTileEntity)te).setModifiers(this.modifiers);
            }
        });
        ctx.setPacketHandled(true);
    }
}

