/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.rftools.blocks.builder.BuilderSetup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ShapeBlockInfo {
    private static final Col COL_DEFAULT = new Col(0.5f, 0.3f, 0.5f);
    private static final Col COL_LAVA = new Col(0.83137256f, 0.3529412f, 0.07058824f);
    private static final Col COL_NETHERBRICK = new Col(0.1764706f, 0.09019608f, 0.105882354f);
    private static final Col COL_SCANNER = new Col(0.0f, 0.0f, 0.8862745f);
    private static final IBlockRender BD_RAIL = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_GRASS = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_TORCH = new DefaultRender(0.4f, 0.7f);
    private static final IBlockRender BD_FLOWER = new DefaultRender(0.4f, 0.6f);
    private static final IBlockRender BD_MUSHROOM = new DefaultRender(0.3f, 0.5f);
    private static final IBlockRender BD_BARS = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_VINE = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_WALL = new DefaultRender(0.25f, 0.9f);
    private static final IBlockRender BD_FENCE = new DefaultRender(0.3f, 0.9f);
    private static final IBlockRender BD_SLAB = new DefaultRender(0.05f, 0.5f);
    private static final IBlockRender BD_SLAB_UPPER = new UpperslabRender(0.05f, 0.5f);
    private static final IBlockRender BD_SNOWLAYER = new DefaultRender(0.0f, 0.3f);
    private static final IBlockRender BD_FIRE = new DefaultRender(0.1f, 0.3f);
    private static final IBlockRender BD_REDSTONE = new DefaultRender(0.3f, 0.1f);
    private static final IBlockRender BD_CHEST = new DefaultRender(0.05f, 0.8f);
    private static final IBlockRender BD_TRAPDOOR = new DefaultRender(0.05f, 0.1f);
    private static final IBlockRender BD_BUTTON = new DefaultRender(0.4f, 0.1f);
    private final Col col;
    private final IBlockRender render;
    private static final Set<Block> nonSolidBlocks = new HashSet<Block>();

    public static boolean isNonSolidBlock(Block b) {
        return nonSolidBlocks.contains(b);
    }

    public ShapeBlockInfo(Col col, IBlockRender render) {
        this.col = col;
        this.render = render;
    }

    private static IBlockRender getBlockRender(IBlockState state) {
        if (state == null) {
            return null;
        }
        IBlockRender render = null;
        Block block = state.getBlock();
        if (block == Blocks.TORCH || block == Blocks.REDSTONE_TORCH) {
            render = BD_TORCH;
        } else if (block == Blocks.STONE_SLAB || block == Blocks.WOODEN_SLAB || block == Blocks.PURPUR_SLAB || block == Blocks.STONE_SLAB2) {
            render = state.getValue((IProperty)BlockSlab.HALF) == BlockSlab.EnumBlockHalf.BOTTOM ? BD_SLAB : BD_SLAB_UPPER;
        } else if (block == Blocks.SNOW_LAYER) {
            render = BD_SNOWLAYER;
        } else if (block == Blocks.COBBLESTONE_WALL) {
            render = BD_WALL;
        } else if (block == Blocks.IRON_BARS || block == Blocks.LADDER) {
            render = BD_BARS;
        } else if (block == Blocks.VINE) {
            render = BD_VINE;
        } else if (block == Blocks.RED_FLOWER || block == Blocks.YELLOW_FLOWER || block == Blocks.WHEAT || block == Blocks.CARROTS || block == Blocks.POTATOES || block == Blocks.BEETROOTS) {
            render = BD_FLOWER;
        } else if (block == Blocks.TALLGRASS) {
            render = BD_GRASS;
        } else if (block == Blocks.RAIL || block == Blocks.ACTIVATOR_RAIL || block == Blocks.DETECTOR_RAIL || block == Blocks.GOLDEN_RAIL) {
            render = BD_RAIL;
        } else if (block == Blocks.RED_MUSHROOM || block == Blocks.BROWN_MUSHROOM) {
            render = BD_MUSHROOM;
        } else if (block == Blocks.FIRE) {
            render = BD_FIRE;
        } else if (block == Blocks.REDSTONE_WIRE) {
            render = BD_REDSTONE;
        } else if (block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST) {
            render = BD_CHEST;
        } else if (block == Blocks.TRAPDOOR || block == Blocks.WOODEN_PRESSURE_PLATE || block == Blocks.STONE_PRESSURE_PLATE) {
            render = BD_TRAPDOOR;
        } else if (block == Blocks.LEVER || block == Blocks.STONE_BUTTON || block == Blocks.WOODEN_BUTTON) {
            render = BD_BUTTON;
        } else if (block == Blocks.ACACIA_FENCE || block == Blocks.ACACIA_FENCE_GATE || block == Blocks.BIRCH_FENCE || block == Blocks.BIRCH_FENCE_GATE || block == Blocks.DARK_OAK_FENCE || block == Blocks.DARK_OAK_FENCE_GATE || block == Blocks.JUNGLE_FENCE || block == Blocks.JUNGLE_FENCE_GATE || block == Blocks.OAK_FENCE || block == Blocks.OAK_FENCE_GATE || block == Blocks.NETHER_BRICK_FENCE) {
            render = BD_FENCE;
        }
        return render;
    }

    private static Col getColor(IBlockState state) {
        if (state == null) {
            return COL_DEFAULT;
        }
        Block block = state.getBlock();
        MapColor mapColor = null;
        try {
            mapColor = block.getMapColor(state, (IBlockAccess)Minecraft.getMinecraft().world, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            mapColor = MapColor.RED;
        }
        Col col = block == Blocks.LAVA || block == Blocks.FLOWING_LAVA ? COL_LAVA : (block == Blocks.NETHER_BRICK || block == Blocks.NETHER_BRICK_FENCE || block == Blocks.NETHER_BRICK_STAIRS ? COL_NETHERBRICK : (block == BuilderSetup.scannerBlock ? COL_SCANNER : (mapColor != null ? new Col((float)(mapColor.colorValue >> 16 & 0xFF) / 255.0f, (float)(mapColor.colorValue >> 8 & 0xFF) / 255.0f, (float)(mapColor.colorValue & 0xFF) / 255.0f) : COL_DEFAULT)));
        float r = col.getR();
        float g = col.getG();
        float b = col.getB();
        if (r * 1.2f > 1.0f) {
            r = 0.825f;
        }
        if (g * 1.2f > 1.0f) {
            g = 0.825f;
        }
        if (b * 1.2f > 1.0f) {
            b = 0.825f;
        }
        col = new Col(r, g, b);
        return col;
    }

    @Nonnull
    public static ShapeBlockInfo getBlockInfo(Map<IBlockState, ShapeBlockInfo> palette, IBlockState state) {
        ShapeBlockInfo info = palette.get(state);
        if (info != null) {
            return info;
        }
        info = new ShapeBlockInfo(ShapeBlockInfo.getColor(state), ShapeBlockInfo.getBlockRender(state));
        palette.put(state, info);
        return info;
    }

    public Col getCol() {
        return this.col;
    }

    public IBlockRender getRender() {
        return this.render;
    }

    public boolean isNonSolid() {
        return this.render != null;
    }

    static {
        nonSolidBlocks.add(Blocks.TORCH);
        nonSolidBlocks.add(Blocks.TORCH);
        nonSolidBlocks.add((Block)Blocks.STONE_SLAB);
        nonSolidBlocks.add((Block)Blocks.WOODEN_SLAB);
        nonSolidBlocks.add((Block)Blocks.PURPUR_SLAB);
        nonSolidBlocks.add((Block)Blocks.STONE_SLAB2);
        nonSolidBlocks.add(Blocks.SNOW_LAYER);
        nonSolidBlocks.add(Blocks.COBBLESTONE_WALL);
        nonSolidBlocks.add(Blocks.IRON_BARS);
        nonSolidBlocks.add(Blocks.LADDER);
        nonSolidBlocks.add(Blocks.VINE);
        nonSolidBlocks.add((Block)Blocks.RED_FLOWER);
        nonSolidBlocks.add((Block)Blocks.YELLOW_FLOWER);
        nonSolidBlocks.add(Blocks.WHEAT);
        nonSolidBlocks.add(Blocks.CARROTS);
        nonSolidBlocks.add(Blocks.POTATOES);
        nonSolidBlocks.add(Blocks.BEETROOTS);
        nonSolidBlocks.add((Block)Blocks.TALLGRASS);
        nonSolidBlocks.add(Blocks.RAIL);
        nonSolidBlocks.add(Blocks.ACTIVATOR_RAIL);
        nonSolidBlocks.add(Blocks.DETECTOR_RAIL);
        nonSolidBlocks.add(Blocks.GOLDEN_RAIL);
        nonSolidBlocks.add((Block)Blocks.RED_MUSHROOM);
        nonSolidBlocks.add((Block)Blocks.BROWN_MUSHROOM);
        nonSolidBlocks.add((Block)Blocks.FIRE);
        nonSolidBlocks.add((Block)Blocks.REDSTONE_WIRE);
        nonSolidBlocks.add((Block)Blocks.CHEST);
        nonSolidBlocks.add(Blocks.TRAPPED_CHEST);
        nonSolidBlocks.add(Blocks.TRAPDOOR);
        nonSolidBlocks.add(Blocks.WOODEN_PRESSURE_PLATE);
        nonSolidBlocks.add(Blocks.STONE_PRESSURE_PLATE);
        nonSolidBlocks.add(Blocks.ACACIA_FENCE);
        nonSolidBlocks.add(Blocks.ACACIA_FENCE_GATE);
        nonSolidBlocks.add(Blocks.BIRCH_FENCE);
        nonSolidBlocks.add(Blocks.BIRCH_FENCE_GATE);
        nonSolidBlocks.add(Blocks.DARK_OAK_FENCE);
        nonSolidBlocks.add(Blocks.DARK_OAK_FENCE_GATE);
        nonSolidBlocks.add(Blocks.JUNGLE_FENCE);
        nonSolidBlocks.add(Blocks.JUNGLE_FENCE_GATE);
        nonSolidBlocks.add(Blocks.OAK_FENCE);
        nonSolidBlocks.add(Blocks.OAK_FENCE_GATE);
        nonSolidBlocks.add(Blocks.NETHER_BRICK_FENCE);
        nonSolidBlocks.add(Blocks.LEVER);
        nonSolidBlocks.add(Blocks.STONE_BUTTON);
        nonSolidBlocks.add(Blocks.WOODEN_BUTTON);
    }

    static class Col {
        private final float r;
        private final float g;
        private final float b;

        public Col(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }
    }

    static interface IBlockRender {
        public void render(BufferBuilder var1, int var2, float var3, float var4, float var5);
    }

    static class DefaultRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public DefaultRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.pos((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, 0.0, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
        }
    }

    static class UpperslabRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public UpperslabRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.offset, 0.5, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).color(r, g, b, a).endVertex();
        }
    }

    static class BlockRender
    implements IBlockRender {
        private final float height;
        private final float xoffset;
        private final float zoffset;

        public BlockRender(float xoffset, float zoffset, float height) {
            this.height = 1.0f;
            this.xoffset = xoffset;
            this.zoffset = zoffset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.pos((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r * 0.8f, g * 0.8f, b * 0.8f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r * 1.2f, g * 1.2f, b * 1.2f, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).color(r, g, b, a).endVertex();
            buffer.pos((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).color(r, g, b, a).endVertex();
        }
    }
}

