/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.invchecker;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.List;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class InvCheckerTileEntity
extends LogicTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETAMOUNT = "inv.setCounter";
    public static final String CMD_SETSLOT = "inv.setSlot";
    public static final String CMD_SETOREDICT = "inv.setOreDict";
    public static final String CMD_SETMETA = "inv.setUseMeta";
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_ITEMMATCH = 0;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/invchecker.gui"));
    private int amount = 1;
    private int slot = 0;
    private boolean oreDict = false;
    private boolean useMeta = false;
    private TIntSet set1 = null;
    private int checkCounter = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 1);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirtyClient();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.markDirtyClient();
    }

    public boolean isOreDict() {
        return this.oreDict;
    }

    public void setOreDict(boolean oreDict) {
        this.oreDict = oreDict;
        this.markDirtyClient();
    }

    public boolean isUseMeta() {
        return this.useMeta;
    }

    public void setUseMeta(boolean useMeta) {
        this.useMeta = useMeta;
        this.markDirtyClient();
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.set1 = null;
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkOutput() ? 15 : 0);
    }

    public boolean checkOutput() {
        boolean newout = false;
        EnumFacing inputSide = this.getFacing(this.func_145831_w().func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity te = this.func_145831_w().func_175625_s(inputPos);
        if (InventoryHelper.isInventory((TileEntity)te)) {
            ItemStack stack = ItemStack.field_190927_a;
            if (CapabilityTools.hasItemCapabilitySafe((TileEntity)te)) {
                IItemHandler capability = CapabilityTools.getItemCapabilitySafe((TileEntity)te);
                if (capability == null) {
                    Block errorBlock = this.func_145831_w().func_180495_p(inputPos).func_177230_c();
                    Logging.logError((String)("Block: " + errorBlock.func_149732_F() + " at " + BlockPosTools.toString((BlockPos)inputPos) + " returns null for getCapability(). Report to mod author"));
                } else if (this.slot >= 0 && this.slot < capability.getSlots()) {
                    stack = capability.getStackInSlot(this.slot);
                }
            } else if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                if (this.slot >= 0 && this.slot < inventory.func_70302_i_()) {
                    stack = inventory.func_70301_a(this.slot);
                }
            }
            if (!stack.func_190926_b()) {
                int nr = this.isItemMatching(stack);
                newout = nr >= this.amount;
            }
        }
        return newout;
    }

    private int isItemMatching(ItemStack stack) {
        int nr = 0;
        ItemStack matcher = this.inventoryHelper.getStackInSlot(0);
        if (!matcher.func_190926_b()) {
            if (this.oreDict) {
                if (this.isEqualForOredict(matcher, stack) && (!this.useMeta || matcher.func_77960_j() == stack.func_77960_j())) {
                    nr = stack.func_190916_E();
                }
            } else if (this.useMeta) {
                if (matcher.func_77969_a(stack)) {
                    nr = stack.func_190916_E();
                }
            } else if (matcher.func_77969_a(stack)) {
                nr = stack.func_190916_E();
            }
        } else {
            nr = stack.func_190916_E();
        }
        return nr;
    }

    private boolean isEqualForOredict(ItemStack s1, ItemStack s2) {
        if (this.set1 == null) {
            int[] oreIDs1 = OreDictionary.getOreIDs((ItemStack)s1);
            this.set1 = new TIntHashSet(oreIDs1);
        }
        if (this.set1.isEmpty()) {
            return s1.func_77969_a(s2);
        }
        int[] oreIDs2 = OreDictionary.getOreIDs((ItemStack)s2);
        if (oreIDs2.length == 0) {
            return false;
        }
        TIntHashSet set2 = new TIntHashSet(oreIDs2);
        set2.retainAll((TIntCollection)this.set1);
        return !set2.isEmpty();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.amount = tagCompound.func_74762_e("amount");
        this.slot = tagCompound.func_74762_e("slot");
        this.oreDict = tagCompound.func_74767_n("oredict");
        this.useMeta = tagCompound.func_74767_n("useMeta");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("amount", this.amount);
        tagCompound.func_74768_a("slot", this.slot);
        tagCompound.func_74757_a("oredict", this.oreDict);
        tagCompound.func_74757_a("useMeta", this.useMeta);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETMETA.equals(command)) {
            this.setUseMeta("Match".equals(params.get(ChoiceLabel.PARAM_CHOICE)));
            return true;
        }
        if (CMD_SETOREDICT.equals(command)) {
            this.setOreDict("Use".equals(params.get(ChoiceLabel.PARAM_CHOICE)));
            return true;
        }
        if (CMD_SETSLOT.equals(command)) {
            int slot;
            try {
                slot = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                slot = 0;
            }
            this.setSlot(slot);
            return true;
        }
        if (CMD_SETAMOUNT.equals(command)) {
            int amount;
            try {
                amount = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
            this.setAmount(amount);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        boolean rc = this.checkOutput();
        probeInfo.text(TextFormatting.GREEN + "Output: " + TextFormatting.WHITE + (rc ? "on" : "off"));
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
    }
}

