/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class ScreenControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
SimpleComponent {
    public static final String ACTION_SCAN = "scan";
    public static final String ACTION_DETACH = "detach";
    public static final String COMPONENT_NAME = "screen_controller";
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_SCAN, this::scan), new DefaultAction(ACTION_DETACH, this::detach)};
    }

    public ScreenControllerTileEntity() {
        super((long)ScreenConfiguration.CONTROLLER_MAXENERGY.get(), (long)ScreenConfiguration.CONTROLLER_RECEIVEPERTICK.get());
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get the amount of screens controlled by this controller", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScreenCount(Context context, Arguments args) {
        return new Object[]{this.connectedScreens.size()};
    }

    @Callback(doc="Get a table with coordinates (every coordinate is a table indexed with 'x', 'y', and 'z') for all connected screens", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScreens(Context context, Arguments args) {
        ArrayList result = new ArrayList();
        for (BlockPos screen : this.connectedScreens) {
            HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
            coordinate.put("x", screen.func_177958_n());
            coordinate.put("y", screen.func_177956_o());
            coordinate.put("z", screen.func_177952_p());
            result.add(coordinate);
        }
        return new Object[]{result};
    }

    @Callback(doc="Given a screen coordinate (table indexed by 'x', 'y', and 'z') return the index of that screen", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScreenIndex(Context context, Arguments args) throws Exception {
        Map screen = args.checkTable(0);
        if (!(screen.containsKey("x") && screen.containsKey("y") && screen.containsKey("z"))) {
            throw new IllegalArgumentException("Screen map doesn't contain the right x,y,z coordinate!");
        }
        BlockPos recC = new BlockPos(((Double)screen.get("x")).intValue(), ((Double)screen.get("y")).intValue(), ((Double)screen.get("z")).intValue());
        return this.getScreenIndex(recC);
    }

    private Object[] getScreenIndex(BlockPos coordinate) {
        int i = 0;
        for (BlockPos connectedScreen : this.connectedScreens) {
            if (connectedScreen.equals((Object)coordinate)) {
                return new Object[]{i};
            }
            ++i;
        }
        return null;
    }

    @Callback(doc="Given a screen index return the coordinate (table indexed by 'x', 'y', and 'z') of that screen", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getScreenCoordinate(Context context, Arguments args) throws Exception {
        int index = args.checkInteger(0);
        if (index < 0 || index >= this.connectedScreens.size()) {
            throw new IllegalArgumentException("Screen index out of range!");
        }
        BlockPos screen = this.connectedScreens.get(index);
        HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
        coordinate.put("x", screen.func_177958_n());
        coordinate.put("y", screen.func_177956_o());
        coordinate.put("z", screen.func_177952_p());
        return new Object[]{coordinate};
    }

    @Callback(doc="Add text to all screens listening to the given 'tag'. Parameters are: 'tag', 'text' and 'color' (RGB value)")
    @Optional.Method(modid="opencomputers")
    public Object[] addText(Context context, Arguments args) {
        String tag = args.checkString(0);
        String text = args.checkString(1);
        int color = args.checkInteger(2);
        return this.addText(tag, text, color);
    }

    @Callback(doc="Set text to all screens listening to the given 'tag'. Parameters are: 'tag', 'text' and 'color' (RGB value)")
    @Optional.Method(modid="opencomputers")
    public Object[] setText(Context context, Arguments args) {
        String tag = args.checkString(0);
        String text = args.checkString(1);
        int color = args.checkInteger(2);
        this.clearText(tag);
        return this.addText(tag, text, color);
    }

    private Object[] setText(String tag, String text, int color) {
        this.clearText(tag);
        return this.addText(tag, text, color);
    }

    private Object[] addText(String tag, String text, int color) {
        for (BlockPos screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.func_145831_w().func_175625_s(screen);
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.addText(text, color);
            }
        }
        return null;
    }

    @Callback(doc="Clear text to all screens listening to the given 'tag'. The 'tag' is the only parameter")
    @Optional.Method(modid="opencomputers")
    public Object[] clearText(Context context, Arguments args) {
        String tag = args.checkString(0);
        return this.clearText(tag);
    }

    private Object[] clearText(String tag) {
        for (BlockPos screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.func_145831_w().func_175625_s(screen);
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.clearText();
            }
        }
        return null;
    }

    @Callback(doc="Get a table of all tags supported by all connected screens", getter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getTags(Context context, Arguments args) {
        ArrayList<String> tags = new ArrayList<String>();
        for (BlockPos screen : this.connectedScreens) {
            TileEntity te = this.func_145831_w().func_175625_s(screen);
            if (!(te instanceof ScreenTileEntity)) continue;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
            tags.addAll(screenTileEntity.getTags());
        }
        return new Object[]{tags};
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int[] xes = tagCompound.func_74759_k("screensx");
        int[] yes = tagCompound.func_74759_k("screensy");
        int[] zes = tagCompound.func_74759_k("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.func_177958_n();
            yes[i] = c.func_177956_o();
            zes[i] = c.func_177952_p();
        }
        tagCompound.func_74783_a("screensx", xes);
        tagCompound.func_74783_a("screensy", yes);
        tagCompound.func_74783_a("screensz", zes);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        long rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        long rememberRf = rf = this.getStoredPower();
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.func_145831_w().func_175625_s(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
                int rfModule = screenTileEntity.getTotalRfPerTick() * 20;
                if ((long)rfModule > rf) {
                    screenTileEntity.setPower(false);
                    continue;
                }
                rf -= (long)rfModule;
                screenTileEntity.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                TileEntity te = this.func_145831_w().func_175625_s(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.markDirtyClient();
        }
    }

    private void scan() {
        this.detach();
        int radius = 32 + (int)(this.getInfusedFactor() * 32.0f);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < 0 || y >= 256) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    ScreenTileEntity ste;
                    TileEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (!(this.func_145831_w().func_180495_p(spos).func_177230_c() instanceof ScreenBlock) || !((te = this.func_145831_w().func_175625_s(spos)) instanceof ScreenTileEntity) || (ste = (ScreenTileEntity)te).isConnected() || !ste.isControllerNeeded()) continue;
                    this.connectedScreens.add(spos);
                    ste.setConnected(true);
                }
            }
        }
        this.markDirtyClient();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.func_145831_w().func_175625_s(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ((ScreenTileEntity)te).setPower(false);
            ((ScreenTileEntity)te).setConnected(false);
        }
        this.connectedScreens.clear();
        this.markDirtyClient();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }
}

