/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.jei;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.compat.jei.CrafterRecipeTransferHandler;
import mcjty.rftools.compat.jei.ModularStorageItemRecipeTransferHandler;
import mcjty.rftools.compat.jei.ModularStorageRecipeTransferHandler;
import mcjty.rftools.compat.jei.PacketSendRecipe;
import mcjty.rftools.compat.jei.RemoteStorageItemRecipeTransferHandler;
import mcjty.rftools.compat.jei.StorageScannerRecipeTransferHandler;
import mcjty.rftools.config.GeneralConfiguration;
import mcjty.rftools.network.RFToolsMessages;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@JEIPlugin
public class RFToolsJeiPlugin
implements IModPlugin {
    private static ItemStack getPreferredItem(List<ItemStack> stacks) {
        if (GeneralConfiguration.modPriority.isEmpty()) {
            return stacks.get(0);
        }
        ItemStack preferred = ItemStack.field_190927_a;
        int bestPriority = -1;
        for (ItemStack stack : stacks) {
            String namespace;
            int prio;
            ResourceLocation id;
            if (stack.func_190926_b() || (id = stack.func_77973_b().getRegistryName()) == null || (prio = GeneralConfiguration.modPriority.getOrDefault(namespace = id.func_110624_b(), 0).intValue()) <= bestPriority) continue;
            preferred = stack;
            bestPriority = prio;
        }
        return preferred;
    }

    public static void transferRecipe(Map<Integer, ? extends IGuiIngredient<ItemStack>> guiIngredients, BlockPos pos) {
        ItemStackList items = ItemStackList.create((int)10);
        guiIngredients.forEach((recipeSlot, guiIngredient) -> {
            List allIngredients = guiIngredient.getAllIngredients();
            if (!allIngredients.isEmpty()) {
                items.set(recipeSlot.intValue(), (Object)RFToolsJeiPlugin.getPreferredItem(allIngredients));
            }
        });
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketSendRecipe(items, pos));
    }

    public void register(@Nonnull IModRegistry registry) {
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        if (CrafterConfiguration.enabled.get()) {
            CrafterRecipeTransferHandler.register(transferRegistry);
        }
        ModularStorageRecipeTransferHandler.register(transferRegistry);
        ModularStorageItemRecipeTransferHandler.register(transferRegistry);
        RemoteStorageItemRecipeTransferHandler.register(transferRegistry);
        StorageScannerRecipeTransferHandler.register(transferRegistry);
    }
}

