/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.config;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.thirteen.ConfigSpec;

public class GeneralConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static final int CRAFT_NONE = 0;
    public static final int CRAFT_EASY = 1;
    public static final int CRAFT_HARD = 2;
    public static ConfigSpec.IntValue dimensionalShardRecipeWithDimensions;
    public static ConfigSpec.IntValue dimensionalShardRecipeWithoutDimensions;
    private static ConfigSpec.ConfigValue<List<? extends Integer>> dimensionalShardOregenWithDimensions;
    private static ConfigSpec.ConfigValue<List<? extends Integer>> dimensionalShardOregenWithoutDimensions;
    public static Set<Integer> oregenDimensionsWithDimensions;
    public static Set<Integer> oregenDimensionsWithoutDimensions;
    public static ConfigSpec.IntValue oreMinimumVeinSize;
    public static ConfigSpec.IntValue oreMaximumVeinSize;
    public static ConfigSpec.IntValue oreMaximumVeinCount;
    public static ConfigSpec.IntValue oreMinimumHeight;
    public static ConfigSpec.IntValue oreMaximumHeight;
    public static ConfigSpec.BooleanValue retrogen;
    public static ConfigSpec.IntValue maxMobInjections;
    public static ConfigSpec.IntValue villagerId;
    public static ConfigSpec.ConfigValue<List<? extends String>> modPreferenceList;
    public static Map<String, Integer> modPriority;

    public static void init(ConfigSpec.Builder SERVER_BUILDER, ConfigSpec.Builder CLIENT_BUILDER) {
        SERVER_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        CLIENT_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        oreMinimumVeinSize = SERVER_BUILDER.comment("Minimum vein size of dimensional shard ores").defineInRange("oreMinimumVeinSize", 5, 0, 10000);
        oreMaximumVeinSize = SERVER_BUILDER.comment("Maximum vein size of dimensional shard ores").defineInRange("oreMaximumVeinSize", 8, 0, 10000);
        oreMaximumVeinCount = SERVER_BUILDER.comment("Maximum number of veins for dimensional shard ores").defineInRange("oreMaximumVeinCount", 3, 0, 10000);
        oreMinimumHeight = SERVER_BUILDER.comment("Minimum y level for dimensional shard ores").defineInRange("oreMinimumHeight", 2, 0, 255);
        oreMaximumHeight = SERVER_BUILDER.comment("Maximum y level for dimensional shard ores").defineInRange("oreMaximumHeight", 40, 0, 255);
        retrogen = SERVER_BUILDER.comment("Set to true to enable retrogen").define("retrogen", true);
        dimensionalShardRecipeWithDimensions = SERVER_BUILDER.comment("Craftability of dimensional shards if RFTools Dimension is present: 0=not, 1=easy, 2=hard").defineInRange("dimensionalShardRecipeWithDimensions", 0, 0, 2);
        dimensionalShardRecipeWithoutDimensions = SERVER_BUILDER.comment("Craftability of dimensional shards if RFTools Dimension is not present: 0=not, 1=easy, 2=hard").defineInRange("dimensionalShardRecipeWithoutDimensions", 2, 0, 2);
        dimensionalShardOregenWithDimensions = SERVER_BUILDER.comment("Oregen for dimensional shards in case RFTools Dimensions is present").defineIntList("dimensionalShardOregenWithDimensions", Arrays.asList(-1, 1), o -> o instanceof Integer);
        dimensionalShardOregenWithoutDimensions = SERVER_BUILDER.comment("Oregen for dimensional shards in case RFTools Dimensions is not present").defineIntList("dimensionalShardOregenWithoutDimensions", Arrays.asList(-1, 1), o -> o instanceof Integer);
        maxMobInjections = SERVER_BUILDER.comment("Amount of injections needed to get a fully absorbed mob essence").defineInRange("maxMobInjections", 10, 0, 10000);
        villagerId = SERVER_BUILDER.comment("The ID for the RFTools villager. -1 means disable, 0 means to automatically assigns an id, any other number will use that as fixed id").defineInRange("villagerId", 0, -1, Integer.MAX_VALUE);
        modPreferenceList = CLIENT_BUILDER.comment("A *CLIENT SIDE* of mod IDs whose items are prioritized for ingredient transfer in storage scanners (and other jei accepting grids), order matters").defineList("modPreferenceList", new ArrayList(), o -> o instanceof String);
        SERVER_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }

    public static void resolve() {
        oregenDimensionsWithDimensions.addAll((Collection)dimensionalShardOregenWithDimensions.get());
        oregenDimensionsWithoutDimensions.addAll((Collection)dimensionalShardOregenWithoutDimensions.get());
        List modList = (List)modPreferenceList.get();
        int priority = modList.size();
        for (String mod : modList) {
            modPriority.put(mod, priority--);
        }
    }

    private static int findFreeVillagerId() {
        int id = 10;
        return id;
    }

    static {
        oregenDimensionsWithDimensions = new HashSet<Integer>();
        oregenDimensionsWithoutDimensions = new HashSet<Integer>();
        modPriority = new Object2IntArrayMap();
    }
}

