/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.rftools.blocks.builder.BuilderSetup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ShapeBlockInfo {
    private static final Col COL_DEFAULT = new Col(0.5f, 0.3f, 0.5f);
    private static final Col COL_LAVA = new Col(0.83137256f, 0.3529412f, 0.07058824f);
    private static final Col COL_NETHERBRICK = new Col(0.1764706f, 0.09019608f, 0.105882354f);
    private static final Col COL_SCANNER = new Col(0.0f, 0.0f, 0.8862745f);
    private static final IBlockRender BD_RAIL = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_GRASS = new DefaultRender(0.1f, 0.2f);
    private static final IBlockRender BD_TORCH = new DefaultRender(0.4f, 0.7f);
    private static final IBlockRender BD_FLOWER = new DefaultRender(0.4f, 0.6f);
    private static final IBlockRender BD_MUSHROOM = new DefaultRender(0.3f, 0.5f);
    private static final IBlockRender BD_BARS = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_VINE = new DefaultRender(0.4f, 1.0f);
    private static final IBlockRender BD_WALL = new DefaultRender(0.25f, 0.9f);
    private static final IBlockRender BD_FENCE = new DefaultRender(0.3f, 0.9f);
    private static final IBlockRender BD_SLAB = new DefaultRender(0.05f, 0.5f);
    private static final IBlockRender BD_SLAB_UPPER = new UpperslabRender(0.05f, 0.5f);
    private static final IBlockRender BD_SNOWLAYER = new DefaultRender(0.0f, 0.3f);
    private static final IBlockRender BD_FIRE = new DefaultRender(0.1f, 0.3f);
    private static final IBlockRender BD_REDSTONE = new DefaultRender(0.3f, 0.1f);
    private static final IBlockRender BD_CHEST = new DefaultRender(0.05f, 0.8f);
    private static final IBlockRender BD_TRAPDOOR = new DefaultRender(0.05f, 0.1f);
    private static final IBlockRender BD_BUTTON = new DefaultRender(0.4f, 0.1f);
    private final Col col;
    private final IBlockRender render;
    private static final Set<Block> nonSolidBlocks = new HashSet<Block>();

    public static boolean isNonSolidBlock(Block b) {
        return nonSolidBlocks.contains(b);
    }

    public ShapeBlockInfo(Col col, IBlockRender render) {
        this.col = col;
        this.render = render;
    }

    private static IBlockRender getBlockRender(IBlockState state) {
        if (state == null) {
            return null;
        }
        IBlockRender render = null;
        Block block = state.func_177230_c();
        if (block == Blocks.field_150478_aa || block == Blocks.field_150429_aA) {
            render = BD_TORCH;
        } else if (block == Blocks.field_150333_U || block == Blocks.field_150376_bx || block == Blocks.field_185771_cX || block == Blocks.field_180389_cP) {
            render = state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM ? BD_SLAB : BD_SLAB_UPPER;
        } else if (block == Blocks.field_150431_aC) {
            render = BD_SNOWLAYER;
        } else if (block == Blocks.field_150463_bK) {
            render = BD_WALL;
        } else if (block == Blocks.field_150411_aY || block == Blocks.field_150468_ap) {
            render = BD_BARS;
        } else if (block == Blocks.field_150395_bd) {
            render = BD_VINE;
        } else if (block == Blocks.field_150328_O || block == Blocks.field_150327_N || block == Blocks.field_150464_aj || block == Blocks.field_150459_bM || block == Blocks.field_150469_bN || block == Blocks.field_185773_cZ) {
            render = BD_FLOWER;
        } else if (block == Blocks.field_150329_H) {
            render = BD_GRASS;
        } else if (block == Blocks.field_150448_aq || block == Blocks.field_150408_cc || block == Blocks.field_150319_E || block == Blocks.field_150318_D) {
            render = BD_RAIL;
        } else if (block == Blocks.field_150337_Q || block == Blocks.field_150338_P) {
            render = BD_MUSHROOM;
        } else if (block == Blocks.field_150480_ab) {
            render = BD_FIRE;
        } else if (block == Blocks.field_150488_af) {
            render = BD_REDSTONE;
        } else if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
            render = BD_CHEST;
        } else if (block == Blocks.field_150415_aT || block == Blocks.field_150452_aw || block == Blocks.field_150456_au) {
            render = BD_TRAPDOOR;
        } else if (block == Blocks.field_150442_at || block == Blocks.field_150430_aB || block == Blocks.field_150471_bO) {
            render = BD_BUTTON;
        } else if (block == Blocks.field_180405_aT || block == Blocks.field_180387_bt || block == Blocks.field_180404_aQ || block == Blocks.field_180392_bq || block == Blocks.field_180406_aS || block == Blocks.field_180385_bs || block == Blocks.field_180403_aR || block == Blocks.field_180386_br || block == Blocks.field_180407_aO || block == Blocks.field_180390_bo || block == Blocks.field_150386_bk) {
            render = BD_FENCE;
        }
        return render;
    }

    private static Col getColor(IBlockState state) {
        if (state == null) {
            return COL_DEFAULT;
        }
        Block block = state.func_177230_c();
        MapColor mapColor = null;
        try {
            mapColor = block.func_180659_g(state, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, new BlockPos(0, 0, 0));
        }
        catch (Exception e) {
            mapColor = MapColor.field_151645_D;
        }
        Col col = block == Blocks.field_150353_l || block == Blocks.field_150356_k ? COL_LAVA : (block == Blocks.field_150385_bj || block == Blocks.field_150386_bk || block == Blocks.field_150387_bl ? COL_NETHERBRICK : (block == BuilderSetup.scannerBlock ? COL_SCANNER : (mapColor != null ? new Col((float)(mapColor.field_76291_p >> 16 & 0xFF) / 255.0f, (float)(mapColor.field_76291_p >> 8 & 0xFF) / 255.0f, (float)(mapColor.field_76291_p & 0xFF) / 255.0f) : COL_DEFAULT)));
        float r = col.getR();
        float g = col.getG();
        float b = col.getB();
        if (r * 1.2f > 1.0f) {
            r = 0.825f;
        }
        if (g * 1.2f > 1.0f) {
            g = 0.825f;
        }
        if (b * 1.2f > 1.0f) {
            b = 0.825f;
        }
        col = new Col(r, g, b);
        return col;
    }

    @Nonnull
    public static ShapeBlockInfo getBlockInfo(Map<IBlockState, ShapeBlockInfo> palette, IBlockState state) {
        ShapeBlockInfo info = palette.get(state);
        if (info != null) {
            return info;
        }
        info = new ShapeBlockInfo(ShapeBlockInfo.getColor(state), ShapeBlockInfo.getBlockRender(state));
        palette.put(state, info);
        return info;
    }

    public Col getCol() {
        return this.col;
    }

    public IBlockRender getRender() {
        return this.render;
    }

    public boolean isNonSolid() {
        return this.render != null;
    }

    static {
        nonSolidBlocks.add(Blocks.field_150478_aa);
        nonSolidBlocks.add(Blocks.field_150478_aa);
        nonSolidBlocks.add((Block)Blocks.field_150333_U);
        nonSolidBlocks.add((Block)Blocks.field_150376_bx);
        nonSolidBlocks.add((Block)Blocks.field_185771_cX);
        nonSolidBlocks.add((Block)Blocks.field_180389_cP);
        nonSolidBlocks.add(Blocks.field_150431_aC);
        nonSolidBlocks.add(Blocks.field_150463_bK);
        nonSolidBlocks.add(Blocks.field_150411_aY);
        nonSolidBlocks.add(Blocks.field_150468_ap);
        nonSolidBlocks.add(Blocks.field_150395_bd);
        nonSolidBlocks.add((Block)Blocks.field_150328_O);
        nonSolidBlocks.add((Block)Blocks.field_150327_N);
        nonSolidBlocks.add(Blocks.field_150464_aj);
        nonSolidBlocks.add(Blocks.field_150459_bM);
        nonSolidBlocks.add(Blocks.field_150469_bN);
        nonSolidBlocks.add(Blocks.field_185773_cZ);
        nonSolidBlocks.add((Block)Blocks.field_150329_H);
        nonSolidBlocks.add(Blocks.field_150448_aq);
        nonSolidBlocks.add(Blocks.field_150408_cc);
        nonSolidBlocks.add(Blocks.field_150319_E);
        nonSolidBlocks.add(Blocks.field_150318_D);
        nonSolidBlocks.add((Block)Blocks.field_150337_Q);
        nonSolidBlocks.add((Block)Blocks.field_150338_P);
        nonSolidBlocks.add((Block)Blocks.field_150480_ab);
        nonSolidBlocks.add((Block)Blocks.field_150488_af);
        nonSolidBlocks.add((Block)Blocks.field_150486_ae);
        nonSolidBlocks.add(Blocks.field_150447_bR);
        nonSolidBlocks.add(Blocks.field_150415_aT);
        nonSolidBlocks.add(Blocks.field_150452_aw);
        nonSolidBlocks.add(Blocks.field_150456_au);
        nonSolidBlocks.add(Blocks.field_180405_aT);
        nonSolidBlocks.add(Blocks.field_180387_bt);
        nonSolidBlocks.add(Blocks.field_180404_aQ);
        nonSolidBlocks.add(Blocks.field_180392_bq);
        nonSolidBlocks.add(Blocks.field_180406_aS);
        nonSolidBlocks.add(Blocks.field_180385_bs);
        nonSolidBlocks.add(Blocks.field_180403_aR);
        nonSolidBlocks.add(Blocks.field_180386_br);
        nonSolidBlocks.add(Blocks.field_180407_aO);
        nonSolidBlocks.add(Blocks.field_180390_bo);
        nonSolidBlocks.add(Blocks.field_150386_bk);
        nonSolidBlocks.add(Blocks.field_150442_at);
        nonSolidBlocks.add(Blocks.field_150430_aB);
        nonSolidBlocks.add(Blocks.field_150471_bO);
    }

    static class Col {
        private final float r;
        private final float g;
        private final float b;

        public Col(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }
    }

    static interface IBlockRender {
        public void render(BufferBuilder var1, int var2, float var3, float var4, float var5);
    }

    static class DefaultRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public DefaultRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.0, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.0, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
        }
    }

    static class UpperslabRender
    implements IBlockRender {
        private final float height;
        private final float offset;

        public UpperslabRender(float offset, float height) {
            this.height = height;
            this.offset = offset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.offset, 0.5, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), (double)this.height + 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.offset), 0.5, (double)(1.0f - this.offset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
        }
    }

    static class BlockRender
    implements IBlockRender {
        private final float height;
        private final float xoffset;
        private final float zoffset;

        public BlockRender(float xoffset, float zoffset, float height) {
            this.height = 1.0f;
            this.xoffset = xoffset;
            this.zoffset = zoffset;
        }

        @Override
        public void render(BufferBuilder buffer, int z, float r, float g, float b) {
            float a = 0.5f;
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 0.8f, g * 0.8f, b * 0.8f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r * 1.2f, g * 1.2f, b * 1.2f, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)this.xoffset, 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), (double)this.height, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(1.0f - this.xoffset), 0.0, (double)(1.0f - this.zoffset + (float)z)).func_181666_a(r, g, b, a).func_181675_d();
        }
    }
}

