/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.soundphysics;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.logging.McLazyLogger;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.addon.annotation.Dependency;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.device.AlContextAudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.OutputDevice;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.audio.source.LoopbackSource;
import su.plo.voice.api.client.config.addon.AddonConfig;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureProcessedEvent;
import su.plo.voice.api.client.event.audio.device.DeviceOpenEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceClosedEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceWriteEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.soundphysics.SoundPhysicsModConfig;

@Addon(id="pv-addon-soundphysics", name="gui.plasmovoice.soundphysics", scope=AddonLoaderScope.CLIENT, version="1.1.1", authors={"Apehum"}, dependencies={@Dependency(id="sound_physics_remastered")})
public final class SoundPhysicsAddon
implements AddonInitializer {
    private static final McLazyLogger LOGGER = McLoggerFactory.createLogger((String)"SoundPhysicsAddon");
    private final Map<AlSource, Long> lastCalculated = new ConcurrentHashMap<AlSource, Long>();
    private final Map<AlSource, float[]> lastPosition = new ConcurrentHashMap<AlSource, float[]>();
    private final Pos3d playerPosition = new Pos3d();
    private final Pos3d lastPlayerPosition = new Pos3d();
    @InjectPlasmoVoice
    private PlasmoVoiceClient voiceClient;
    private AddonConfig config;
    private Method soundPhysicsInit;
    private Method soundPhysicsSetEnvironment;
    private Method soundPhysicsPlaySound;
    private Method soundPhysicsSetLastCategoryAndName;
    private Method soundPhysicsReverb;
    private Object masterCategory;
    private LoopbackSource loopbackSource;
    private BooleanConfigEntry enabledEntry;
    private BooleanConfigEntry microphoneReverbEnabledEntry;
    private DoubleConfigEntry microphoneReverbVolumeEntry;

    public void onAddonInitialize() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.sonicether.soundphysics.SoundPhysics");
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("SoundPhysics is not installed", new Object[0]);
                return;
            }
            this.soundPhysicsInit = clazz.getMethod("init", new Class[0]);
            this.soundPhysicsSetLastCategoryAndName = Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals("setLastSoundCategoryAndName")).findFirst().orElse(null);
            Class<?> category = this.soundPhysicsSetLastCategoryAndName.getParameterTypes()[0];
            Object[] values = (Object[])category.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            this.masterCategory = values[0];
            try {
                this.soundPhysicsSetEnvironment = clazz.getMethod("setEnvironment", Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException ignored) {
                this.soundPhysicsSetEnvironment = Class.forName("com.sonicether.soundphysics.SPEfx").getMethod("setEnvironment", Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            this.soundPhysicsPlaySound = clazz.getMethod("onPlaySound", Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
            this.soundPhysicsReverb = clazz.getMethod("onPlayReverb", Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException clazz) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.config = this.voiceClient.getAddonConfig((Object)this);
        this.config.clear();
        this.enabledEntry = this.config.addToggle("enabled", (McTextComponent)McTextComponent.translatable((String)"gui.plasmovoice.soundphysics.enabled", (Object[])new Object[0]), null, true);
        this.enabledEntry.addChangeListener(this::onToggle);
        if (((Boolean)this.enabledEntry.value()).booleanValue()) {
            this.voiceClient.getConfig().getVoice().getSoundOcclusion().setDisabled(true);
        }
        if (this.soundPhysicsReverb != null) {
            this.microphoneReverbEnabledEntry = this.config.addToggle("mic_reverb", (McTextComponent)McTextComponent.translatable((String)"gui.plasmovoice.soundphysics.mic_reverb", (Object[])new Object[0]), (McTextComponent)McTextComponent.translatable((String)"gui.plasmovoice.soundphysics.mic_reverb.tooltip", (Object[])new Object[0]), true);
            this.microphoneReverbEnabledEntry.addChangeListener(this::onReverbToggle);
            this.microphoneReverbVolumeEntry = this.config.addVolumeSlider("mic_reverb_volume", (McTextComponent)McTextComponent.translatable((String)"gui.plasmovoice.soundphysics.mic_reverb_volume", (Object[])new Object[0]), null, "%", 1.0, 0.0, 2.0);
        }
    }

    @EventSubscribe
    public void onDeviceOpen(@NotNull DeviceOpenEvent event) {
        if (!(event.getDevice() instanceof AlContextAudioDevice && event.getDevice() instanceof OutputDevice && this.isEnabled())) {
            return;
        }
        if (this.soundPhysicsInit != null) {
            try {
                this.soundPhysicsInit.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    @EventSubscribe
    public void onSourceClose(@NotNull AlSourceClosedEvent event) {
        this.lastCalculated.remove(event.getSource());
        this.lastPosition.remove(event.getSource());
    }

    @EventSubscribe
    public void onAudioCaptureProcessed(@NotNull AudioCaptureProcessedEvent event) {
        if (!this.isEnabled() || !this.isMicrophoneReverbEnabled() || this.soundPhysicsReverb == null) {
            return;
        }
        if (this.voiceClient.getActivationManager().getActivations().stream().filter(Activation::isProximity).noneMatch(ClientActivation::isActive)) {
            return;
        }
        if (this.loopbackSource == null || this.loopbackSource.isClosed()) {
            try {
                this.loopbackSource = this.voiceClient.getSourceManager().createLoopbackSource(false);
                if (this.microphoneReverbVolumeEntry != null) {
                    this.loopbackSource.setVolumeEntry(this.microphoneReverbVolumeEntry);
                }
                this.loopbackSource.initialize(false);
            }
            catch (DeviceException e) {
                LOGGER.warn("Failed to initialize loopback source for SoundPhysics integration", new Object[]{e});
                return;
            }
        }
        short[] samples = event.getProcessed().getSamples(false);
        this.loopbackSource.write(samples);
    }

    @EventSubscribe
    public void onSourceWrite(@NotNull AlSourceWriteEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        AlSource alSource = event.getSource();
        alSource.getDevice().runInContextAsync(() -> {
            if (alSource.getInt(514) == 1) {
                return;
            }
            long lastCalculated = this.lastCalculated.getOrDefault(alSource, 0L);
            if (System.currentTimeMillis() - lastCalculated < 500L) {
                return;
            }
            float[] lastPosition = this.lastPosition.get(alSource);
            float[] position = new float[3];
            alSource.getFloatArray(4100, position);
            if (this.loopbackSource != null && this.loopbackSource.getSource().isPresent() && ((AlSource)this.loopbackSource.getSource().get()).equals(alSource)) {
                this.soundPhysicsUpdate(alSource, lastPosition, position, this.soundPhysicsReverb);
            } else {
                this.soundPhysicsUpdate(alSource, lastPosition, position, this.soundPhysicsPlaySound);
            }
        });
    }

    private void soundPhysicsUpdate(AlSource alSource, float[] lastPosition, float[] position, Method soundPhysicsMethod) {
        if (this.evaluate(alSource, lastPosition, position) || soundPhysicsMethod == this.soundPhysicsReverb) {
            try {
                if (lastPosition == null) {
                    this.soundPhysicsSetEnvironment.invoke(null, (int)alSource.getPointer(), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(soundPhysicsMethod == this.soundPhysicsReverb ? 0.0f : 1.0f));
                }
                this.soundPhysicsSetLastCategoryAndName.invoke(null, this.masterCategory, "voicechat");
                soundPhysicsMethod.invoke(null, position[0], position[1], position[2], (int)alSource.getPointer());
                this.lastPosition.put(alSource, position);
                this.setPlayerPosition(this.lastPlayerPosition);
                if (lastPosition != null) {
                    this.lastCalculated.put(alSource, System.currentTimeMillis());
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean evaluate(AlSource alSource, float[] lastPosition, float[] position) {
        return lastPosition == null || !this.lastCalculated.containsKey(alSource) || this.distance(position, lastPosition) > 0.25 || this.distancePlayerTraveled() > 0.25;
    }

    private double distancePlayerTraveled() {
        this.setPlayerPosition(this.playerPosition);
        return Math.sqrt(this.playerPosition.distanceSquared(this.lastPlayerPosition));
    }

    private double distance(float[] position1, float[] position2) {
        double d = position1[0] - position2[0];
        double e = position1[1] - position2[1];
        double f = position1[2] - position2[2];
        return Math.sqrt(d * d + e * e + f * f);
    }

    private Pos3d setPlayerPosition(Pos3d position) {
        Class<?> uPlayer;
        try {
            uPlayer = Class.forName("gg.essential.universal.wrappers.UPlayer");
        }
        catch (Exception ignored) {
            try {
                uPlayer = Class.forName("su.plo.voice.universal.wrappers.UPlayer");
            }
            catch (Exception ignored1) {
                return position;
            }
        }
        try {
            boolean hasPlayer = (Boolean)uPlayer.getMethod("hasPlayer", new Class[0]).invoke(null, new Object[0]);
            if (!hasPlayer) {
                return position;
            }
            position.setX(((Double)uPlayer.getMethod("getPosX", new Class[0]).invoke(null, new Object[0])).doubleValue());
            position.setY(((Double)uPlayer.getMethod("getPosY", new Class[0]).invoke(null, new Object[0])).doubleValue());
            position.setZ(((Double)uPlayer.getMethod("getPosZ", new Class[0]).invoke(null, new Object[0])).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return position;
    }

    private void onToggle(boolean enabled) {
        this.voiceClient.getConfig().getVoice().getSoundOcclusion().setDisabled(enabled);
        this.voiceClient.getDeviceManager().getOutputDevice().ifPresent(device -> {
            try {
                device.reload();
                if (this.loopbackSource != null) {
                    this.loopbackSource.close();
                    this.loopbackSource = null;
                }
            }
            catch (DeviceException e) {
                LOGGER.warn("Failed to reload device", new Object[]{e});
            }
        });
    }

    private void onReverbToggle(boolean enabled) {
        if (!enabled && this.loopbackSource != null) {
            this.loopbackSource.close();
            this.loopbackSource = null;
        }
    }

    private boolean isEnabled() {
        return this.enabledEntry != null && (Boolean)this.enabledEntry.value() != false && SoundPhysicsModConfig.isEnabled();
    }

    private boolean isMicrophoneReverbEnabled() {
        return this.microphoneReverbEnabledEntry != null && (Boolean)this.microphoneReverbEnabledEntry.value() != false;
    }
}

