/*
 * Decompiled with CFR 0.152.
 */
package net.superkat.explosiveenhancement;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.superkat.explosiveenhancement.ExplosiveEnhancement;
import net.superkat.explosiveenhancement.ExplosiveHandler;
import net.superkat.explosiveenhancement.api.ExplosionParticleType;
import net.superkat.explosiveenhancement.api.ExplosiveApi;
import net.superkat.explosiveenhancement.config.ExplosiveConfig;
import net.superkat.explosiveenhancement.network.S2CExplosiveEnhancementParticles;
import net.superkat.explosiveenhancement.particles.normal.BlastWaveParticle;
import net.superkat.explosiveenhancement.particles.normal.FireballParticle;
import net.superkat.explosiveenhancement.particles.normal.NoRender;
import net.superkat.explosiveenhancement.particles.normal.SmokeParticle;
import net.superkat.explosiveenhancement.particles.normal.SparkParticle;
import net.superkat.explosiveenhancement.particles.underwater.BubbleParticle;
import net.superkat.explosiveenhancement.particles.underwater.ShockwaveParticle;
import net.superkat.explosiveenhancement.particles.underwater.UnderwaterBlastWaveParticle;
import net.superkat.explosiveenhancement.particles.underwater.UnderwaterSparkParticle;

public class ExplosiveEnhancementClient
implements ClientModInitializer {
    public static ExplosiveConfig CONFIG = ExplosiveConfig.INSTANCE;

    public void onInitializeClient() {
        ExplosiveConfig.load();
        if (!FabricLoader.getInstance().isDevelopmentEnvironment() && !ExplosiveEnhancementClient.YaclLoaded()) {
            ExplosiveEnhancement.LOGGER.warn("[Explosive Enhancement]: YetAnotherConfigLib is not installed! If you wish to edit Explosive Enhancement's config, please install it!");
        }
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.BLASTWAVE, BlastWaveParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.FIREBALL, FireballParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.BLANK_FIREBALL, FireballParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.SMOKE, SmokeParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.SPARKS, SparkParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.BUBBLE, BubbleParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.SHOCKWAVE, ShockwaveParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.BLANK_SHOCKWAVE, ShockwaveParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.UNDERWATERBLASTWAVE, UnderwaterBlastWaveParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.UNDERWATERSPARKS, UnderwaterSparkParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)ExplosiveEnhancement.NO_RENDER_PARTICLE, NoRender.Factory::new);
        ClientPlayNetworking.registerGlobalReceiver(S2CExplosiveEnhancementParticles.ID, (payload, context) -> {
            if (ExplosiveEnhancementClient.CONFIG.bypassPowerForSingleplayer) {
                boolean showVanillaParticles;
                class_638 world = context.client().field_1687;
                double x = payload.x();
                double y = payload.y();
                double z = payload.z();
                ExplosionParticleType explosionParticleType = ExplosiveApi.determineParticleType((class_1937)world, new class_243(x, y, z), payload.initParticle());
                float power = payload.power();
                if (ExplosiveEnhancementClient.CONFIG.extraPower) {
                    power += ExplosiveHandler.particlesAreEmitter(payload.initParticle()) ? ExplosiveEnhancementClient.CONFIG.bigExtraPower : ExplosiveEnhancementClient.CONFIG.smallExtraPower;
                }
                ExplosiveApi.spawnParticles((class_1937)world, x, y, z, power, explosionParticleType);
                boolean bl = showVanillaParticles = ExplosiveEnhancementClient.CONFIG.showDefaultExplosion && explosionParticleType == ExplosionParticleType.NORMAL || ExplosiveEnhancementClient.CONFIG.showDefaultExplosionUnderwater && explosionParticleType == ExplosionParticleType.WATER;
                if (showVanillaParticles) {
                    world.method_8406(payload.initParticle(), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        });
    }

    public static boolean YaclLoaded() {
        return FabricLoader.getInstance().isModLoaded("yet_another_config_lib_v3");
    }
}

