/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.EntityRegistrationEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1421;
import net.minecraft.class_1427;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1646;

public class EntityRegistrationFactory {
    private EntityRegistrationEvent event;
    private List<Class<? extends class_1297>> passives;
    private List<Class<? extends class_1297>> hostiles;
    private List<Class<? extends class_1297>> villagers;
    private List<Class<? extends class_1297>> ambient;
    private List<Class<? extends class_1297>> entities;
    private static EntityRegistrationFactory instance;

    public static void init() {
        EntityRegistrationFactory.prepare();
        ClientEventRegistry.ENTITY_REGISTRATION_EVENT.subscribe("journeymap", EntityRegistrationFactory::register);
        EventBus.post(EntityRegistrationFactory.getInstance().event);
    }

    private static void prepare() {
        EntityRegistrationFactory factory = EntityRegistrationFactory.getInstance();
        HashMap entityClasses = new HashMap();
        entityClasses.put(EntityRegistrationEvent.Type.PASSIVE, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.HOSTILE, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.VILLAGER, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.AMBIENT, new ArrayList());
        entityClasses.put(EntityRegistrationEvent.Type.ENTITY, new ArrayList());
        factory.event = new EntityRegistrationEvent(entityClasses);
    }

    private static void register(EntityRegistrationEvent event) {
        event.addHostileEntity(class_1314.class).addVillagerEntity(class_1646.class).addPassiveEntity(class_1429.class).addPassiveEntity(class_1427.class).addPassiveEntity(class_1480.class).addPassiveEntity(class_1314.class).addAmbientEntity(class_1421.class);
    }

    public static EntityRegistrationFactory getInstance() {
        if (instance == null) {
            instance = new EntityRegistrationFactory();
        }
        return instance;
    }

    public List<Class<? extends class_1297>> getPassives() {
        if (this.passives == null) {
            this.passives = this.event.getEntityClasses(EntityRegistrationEvent.Type.PASSIVE);
        }
        return this.passives;
    }

    public List<Class<? extends class_1297>> getHostiles() {
        if (this.hostiles == null) {
            this.hostiles = this.event.getEntityClasses(EntityRegistrationEvent.Type.HOSTILE);
        }
        return this.hostiles;
    }

    public List<Class<? extends class_1297>> getVillagers() {
        if (this.villagers == null) {
            this.villagers = this.event.getEntityClasses(EntityRegistrationEvent.Type.VILLAGER);
        }
        return this.villagers;
    }

    public List<Class<? extends class_1297>> getAmbient() {
        if (this.ambient == null) {
            this.ambient = this.event.getEntityClasses(EntityRegistrationEvent.Type.AMBIENT);
        }
        return this.ambient;
    }

    public List<Class<? extends class_1297>> getEntities() {
        if (this.entities == null) {
            this.entities = this.event.getEntityClasses(EntityRegistrationEvent.Type.ENTITY);
        }
        return this.entities;
    }
}

