/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class WaypointPanel<T extends WaypointSlot>
extends ScrollListLayoutPane<T> {
    final int offset = 6;
    WaypointSlot draggingSlot = null;

    public WaypointPanel(class_310 mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, x, y, width, height, slotHeight);
    }

    public int method_25342() {
        return super.method_25342();
    }

    @Override
    public void updateSize(int width, int height, int x, int y) {
        super.method_55444(width, height, x - 3, y);
        this.scrollbarX = this.field_22758 + x - 6;
        this.listWidth = this.field_22758 - 6;
    }

    @Override
    public void setListWidth(int width) {
        this.scrollbarX = (this.field_22758 + width) / 2 - 6;
        this.listWidth = width - 6;
    }

    @Override
    public void method_44397(class_332 graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            WaypointSlot slot = (WaypointSlot)this.method_25326(index);
            super.method_44397(graphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (slot.method_25397()) {
                this.draggingSlot = slot;
            }
            if (this.draggingSlot != null && (this.method_25319(index + 1) > this.method_55443() || index + 1 >= this.method_25396().size())) {
                graphics.method_44380();
                if (this.draggingSlot.isSelected()) {
                    graphics.method_51448().method_22903();
                    List<WaypointSlot> slots = this.getRootSlots().stream().filter(WaypointSlot::isSelected).toList();
                    int boxWidth = this.draggingSlot.name.method_25368() + this.draggingSlot.icon.method_25368() + 20;
                    int boxHeight = height * slots.size();
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, boxWidth, boxHeight, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, boxWidth, boxHeight + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.field_22765 * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                    int slotIndex = 1;
                    for (WaypointSlot renderSlot : slots) {
                        if (renderSlot == this.draggingSlot) continue;
                        renderSlot.renderGhost(graphics, mouseX, mouseY + height * slotIndex++, partialTick);
                    }
                    float texScale = 0.2f;
                    int posX = mouseX + (boxWidth >> 1);
                    int posY = mouseY + (boxHeight >> 1);
                    class_1043 texture = TextureCache.getTexture(TextureCache.MobIconBG);
                    float scaleX = (float)posX - (float)texture.method_4525().method_4307() * texScale / 2.0f;
                    float scaleY = (float)posY - (float)texture.method_4525().method_4323() * texScale / 2.0f;
                    graphics.method_51448().method_46416(0.0f, 0.0f, 10.0f);
                    DrawUtil.drawColoredImage(graphics.method_51448(), TextureCache.getTexture(TextureCache.MobIconBG), 0xFF0000, 0.4f, scaleX, scaleY, texScale, 0.0);
                    DrawUtil.drawCenteredLabel(graphics, Integer.toString(slots.size()), posX, posY, null, 0.0f, 0xFFFFFF, 0.8f, 2.0, false);
                    graphics.method_51448().method_22909();
                } else {
                    int slotWidth = this.draggingSlot.name.method_25368() + this.draggingSlot.icon.method_25368() + 20;
                    DrawUtil.drawRectangle(graphics, mouseX, mouseY, slotWidth, height, ManagerSlot.backgroundHover, 0.4f);
                    this.draggingSlot.outline(graphics, mouseX, mouseY - 1, slotWidth, height + 1, this.draggingSlot.getWaypoint().getRenderColor(), this.field_22765 * 2.0f);
                    this.draggingSlot.renderGhost(graphics, mouseX, mouseY, partialTick);
                }
                this.method_49603(graphics);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error rendering waypoint slot item:", t);
        }
    }

    @Override
    public void renderBackground(class_332 graphics, int i, int j, float f) {
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingSlot = null;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.method_25405(mouseX, mouseY)) {
            this.getRootSlots().forEach(slot -> slot.getLayout().method_48206(widget -> widget.method_25402(mouseX, mouseY, button)));
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public List<WaypointSlot> getDraggingSlots() {
        if (this.draggingSlot != null) {
            if (this.draggingSlot.isSelected()) {
                return this.getRootSlots().stream().filter(WaypointSlot::isSelected).collect(Collectors.toList());
            }
            return Lists.newArrayList((Object[])new WaypointSlot[]{this.draggingSlot});
        }
        return null;
    }

    @Override
    public void visitSlots(Consumer<class_339> consumer) {
        this.getRootSlots().forEach(slot -> {
            if (slot != null && slot.getLayout() != null) {
                slot.getLayout().method_48206(consumer);
            }
        });
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(WaypointSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(WaypointSlot::repositionElements);
    }
}

