/*
 * Decompiled with CFR 0.152.
 */
package xyz.trivaxy.tia;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import xyz.trivaxy.tia.Commons;
import xyz.trivaxy.tia.ModConfigs;

public class FabricConfigs {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("tia.json");
    private static final File CONFIG_FILE = CONFIG_PATH.toFile();

    public static void load() {
        if (!CONFIG_FILE.isFile()) {
            Commons.LOGGER.info("Config file not found, creating one...");
            try {
                FabricConfigs.createDefaultConfigFile();
            }
            catch (IOException e) {
                FabricConfigs.logError("Could not create config file", e);
                return;
            }
        }
        try {
            JsonObject config = (JsonObject)GSON.fromJson(Files.readString(CONFIG_PATH), JsonObject.class);
            ModConfigs.animationSpeed = config.get("animation_speed").getAsFloat();
            ModConfigs.pickupScale = config.get("pickup_scale").getAsFloat();
        }
        catch (IOException e) {
            FabricConfigs.logError("Could not read config file", e);
        }
        catch (NullPointerException e) {
            FabricConfigs.logError("Config file is invalid", e);
        }
    }

    private static void createDefaultConfigFile() throws IOException {
        JsonObject config = new JsonObject();
        config.addProperty("animation_speed", (Number)Float.valueOf(ModConfigs.getDefaultAnimationSpeed()));
        config.addProperty("pickup_scale", (Number)Float.valueOf(ModConfigs.getDefaultPickupScale()));
        BufferedWriter writer = new BufferedWriter(new FileWriter(CONFIG_FILE, false));
        writer.write(GSON.toJson((JsonElement)config));
        writer.close();
    }

    private static void logError(String message, Exception exception) {
        Commons.LOGGER.error(message + ": " + exception.getMessage());
        Commons.LOGGER.error("Using default values instead");
    }
}

