package com.provismet.CombatPlusCore;

import com.provismet.CombatPlusCore.debug.registries.CPCDebugItems;
import com.provismet.CombatPlusCore.event.handler.ItemEvents;
import com.provismet.CombatPlusCore.registries.CPCDataComponentEffects;
import com.provismet.CombatPlusCore.registries.CPCDataComponentTypes;
import com.provismet.CombatPlusCore.registries.CPCEnchantmentComponentTypes;
import com.provismet.CombatPlusCore.registries.CPCEntityAttributes;
import com.provismet.CombatPlusCore.registries.CPCLootFunctionTypes;
import com.provismet.CombatPlusCore.registries.DoubleEntityEffects;
import com.provismet.CombatPlusCore.registries.DoubleEntityLootConditionTypes;
import com.provismet.CombatPlusCore.registries.ItemConditionTypes;
import com.provismet.CombatPlusCore.registries.LambdaRegistry;
import com.provismet.CombatPlusCore.registries.SingleEntityEffects;
import com.provismet.CombatPlusCore.registries.SingleEntityLootConditionTypes;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import com.provismet.CombatPlusCore.utility.CPCCallbackUtil;
import com.provismet.lilylib.datagen.condition.LilyResourceConditions;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.provismet.CombatPlusCore.api.CombatPlusEntrypoint;
import com.provismet.CombatPlusCore.utility.CPCGameRules;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7706;

public class CPCMain implements ModInitializer {
    public static final String MODID = "combat-plus";
    public static final Logger LOGGER = LoggerFactory.getLogger("Combat+ Core");

    public static class_2960 identifier (String path) {
        return class_2960.method_60655(MODID, path);
    }

    @Override
    public void onInitialize () {
        CPCEntityAttributes.init();
        CPCRegistries.init();
        CPCLootFunctionTypes.init();
        CPCEnchantmentComponentTypes.init();
        SingleEntityLootConditionTypes.init();
        DoubleEntityLootConditionTypes.init();
        ItemConditionTypes.init();
        DoubleEntityEffects.register();
        LambdaRegistry.register();
        CPCGameRules.init();
        SingleEntityEffects.register();
        CPCDataComponentEffects.register();
        CPCDataComponentTypes.init();
        ItemEvents.RegisterComponentPhase();

        LilyResourceConditions.register();

        FabricLoader.getInstance().getModContainer(MODID).ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack(identifier("enchanted_numerals"), container, class_2561.method_43471("resourcepack.combat-plus.enchanted_numerals"), ResourcePackActivationType.DEFAULT_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack(identifier("enchanted_numbers"), container, class_2561.method_43471("resourcepack.combat-plus.enchanted_numbers"), ResourcePackActivationType.NORMAL);
        });

        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            LOGGER.warn("Combat+ Core development code is running. If you see this, you should be in a development environment.");
            CPCDebugItems.register();
            ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> {
                CPCDebugItems.getOptionalDebugItem().ifPresent(item -> content.method_45422(item, class_1761.class_7705.field_40193));
                CPCDebugItems.getOptionalDebugShield().ifPresent(item -> content.method_45422(item, class_1761.class_7705.field_40193));
            });
        }

        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, target, damageSource) -> {
            if (entity instanceof class_1309 user) {
                CPCCallbackUtil.postKill(world, user.method_6047(), class_1304.field_6173, user, target);
            }
        });

        FabricLoader.getInstance().getEntrypointContainers(MODID, CombatPlusEntrypoint.class).forEach(
            entrypoint -> {
                String otherModId = entrypoint.getProvider().getMetadata().getId();
                try {
                    entrypoint.getEntrypoint().onInitialize();
                }
                catch (Exception e) {
                    LOGGER.error("Mod {} caused an error during inter-mod initialisation: ", otherModId, e);
                }
            }
        );
    }
}