package com.provismet.CombatPlusCore.enchantment.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public interface CPCDataComponentEntityEffect<T> {
    Codec<CPCDataComponentEntityEffect<?>> CODEC = CPCRegistries.ENCHANTMENT_DATA_COMPONENT_EFFECT_TYPE.method_39673().dispatch(CPCDataComponentEntityEffect::getCodec, Function.identity());

    default void apply (class_1799 stack, int level) {
        if (stack.method_58694(this.getComponentType()) == null) {
            stack.method_57379(this.getComponentType(), this.getComponent(level));
        }
    }

    default void remove (class_1799 stack, int level) {
        // Would this item normally have this component? If so then assume the enchantment never applied a new version.
        if (stack.method_7909().method_7854().method_58694(this.getComponentType()) == null) {
            stack.method_57381(this.getComponentType());
        }
    }

    T getComponent (int level);
    class_9331<T> getComponentType ();
    MapCodec<? extends CPCDataComponentEntityEffect<?>> getCodec ();
}
