package com.provismet.CombatPlusCore.enchantment.effect;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_9699;

/**
 * Combat+ Enchantment Effect for effects that can look at both the attacker and the target simultaneously.
 *
 * @see com.provismet.CombatPlusCore.registries.DoubleEntityEffects
 */
public interface CPCEnchantmentEntityEffect {
    Codec<CPCEnchantmentEntityEffect> CODEC = CPCRegistries.ENCHANTMENT_DUAL_ENTITY_EFFECT_TYPE.method_39673().dispatch(CPCEnchantmentEntityEffect::getCodec, Function.identity());

    void apply (class_3218 world, int level, class_9699 context, class_1297 attacker, class_1297 target);
    MapCodec<? extends CPCEnchantmentEntityEffect> getCodec ();
}
