package com.provismet.CombatPlusCore.enchantment.effect.component;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.effect.CPCDataComponentEntityEffect;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10707;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9704;

public record BlocksAttacksComponentEntityEffect (
    class_9704 blockDelaySeconds,
    class_9704 disableCooldownScale,
    List<class_10707.class_10708> damageReductions,
    class_10707.class_10709 itemDamage,
    Optional<class_6862<class_8110>> bypassedBy,
    Optional<class_6880<class_3414>> blockSound,
    Optional<class_6880<class_3414>> disableSound)
    implements CPCDataComponentEntityEffect<class_10707>
{
    public static final MapCodec<BlocksAttacksComponentEntityEffect> CODEC = RecordCodecBuilder.mapCodec(
        instance -> instance.group(
            class_9704.field_51690.optionalFieldOf("block_delay_seconds", class_9704.method_60186(0)).forGetter(BlocksAttacksComponentEntityEffect::blockDelaySeconds),
            class_9704.field_51690.optionalFieldOf("disable_cooldown_scale", class_9704.method_60186(1)).forGetter(BlocksAttacksComponentEntityEffect::disableCooldownScale),
            class_10707.class_10708.field_56303.listOf().optionalFieldOf("damage_reductions", List.of(new class_10707.class_10708(90f, Optional.empty(), 0f, 1f))).forGetter(BlocksAttacksComponentEntityEffect::damageReductions),
            class_10707.class_10709.field_56306.optionalFieldOf("item_damage", class_10707.class_10709.field_56308).forGetter(BlocksAttacksComponentEntityEffect::itemDamage),
            class_6862.method_40093(class_7924.field_42534).optionalFieldOf("bypassed_by").forGetter(BlocksAttacksComponentEntityEffect::bypassedBy),
            class_3414.field_41699.optionalFieldOf("block_sound").forGetter(BlocksAttacksComponentEntityEffect::blockSound),
            class_3414.field_41699.optionalFieldOf("disabled_sound").forGetter(BlocksAttacksComponentEntityEffect::disableSound)
        ).apply(instance, BlocksAttacksComponentEntityEffect::new)
    );

    @Override
    public MapCodec<BlocksAttacksComponentEntityEffect> getCodec () {
        return CODEC;
    }

    @Override
    public class_10707 getComponent (int level) {
        return new class_10707(
            this.blockDelaySeconds.method_60188(level),
            this.disableCooldownScale.method_60188(level),
            this.damageReductions,
            this.itemDamage,
            this.bypassedBy,
            this.blockSound,
            this.disableSound
        );
    }

    @Override
    public class_9331<class_10707> getComponentType () {
        return class_9334.field_56396;
    }
}
