package com.provismet.CombatPlusCore.enchantment.effect.doubleEntity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.enchantment.effect.CPCEnchantmentEntityEffect;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9699;
import net.minecraft.class_9704;

/**
 * Applies velocity, launching the target away from the attacker.
 * @param strength The strength of the knockback.
 * @param respectAttribute Whether or not this should respect knockback resistance.
 */
public record ApplyKnockbackEffect (class_9704 strength, boolean respectAttribute) implements CPCEnchantmentEntityEffect {
    public static final MapCodec<ApplyKnockbackEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(class_9704.field_51690.fieldOf("strength").forGetter(ApplyKnockbackEffect::strength),
            Codec.BOOL.fieldOf("respect_knockback_resistance").forGetter(ApplyKnockbackEffect::respectAttribute)
        ).apply(instance, ApplyKnockbackEffect::new)
    );

    @Override
    public void apply (class_3218 world, int level, class_9699 context, class_1297 attacker, class_1297 target) {
        double strengthValue = this.strength.method_60188(level);

        if (this.respectAttribute && target instanceof class_1309 living) {
            strengthValue *= 1 - living.method_45325(class_5134.field_23718);
            if (strengthValue <= 0) return;
        }
        class_243 velocity = new class_243(target.method_23317() - attacker.method_23317(), 0.0, target.method_23321() - attacker.method_23321()).method_1029().method_1021(strengthValue).method_1031(0.0, 0.1, 0.0);
        target.method_60491(velocity);
        target.field_6037 = true;
    }

    @Override
    public MapCodec<? extends CPCEnchantmentEntityEffect> getCodec () {
        return CODEC;
    }
}
