package com.provismet.CombatPlusCore.enchantment.effect.doubleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.effect.CPCEnchantmentEntityEffect;
import com.provismet.CombatPlusCore.enchantment.effect.singleEntity.CodeExecutionSingleEntityEffect;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9699;

/**
 * Executes a registered function against the pair of entities.
 * @see CodeExecutionSingleEntityEffect
 * @param function The identifier of the function.
 */
public record CodeExecutionDoubleEntityEffect (class_2960 function) implements CPCEnchantmentEntityEffect {
    public static final MapCodec<CodeExecutionDoubleEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_2960.field_25139.fieldOf("function").forGetter(CodeExecutionDoubleEntityEffect::function)
        ).apply(instance, CodeExecutionDoubleEntityEffect::new)
    );

    @Override
    public void apply (class_3218 world, int level, class_9699 context, class_1297 attacker, class_1297 target) {
        Lambda lambda = CPCRegistries.DOUBLE_ENTITY_LAMBDA.method_63535(this.function);
        if (lambda == null) {
            CPCMain.LOGGER.warn("Enchantment attempted to execute unregistered lambda function: {}", this.function.toString());
            return;
        }
        lambda.execute(world, level, context, attacker, target, attacker.method_73189());
    }

    @Override
    public MapCodec<? extends CPCEnchantmentEntityEffect> getCodec() {
        return CODEC;
    }

    @FunctionalInterface
    public interface Lambda {
        void execute (class_3218 world, int level, class_9699 context, class_1297 user, class_1297 target, class_243 pos);
    }
}
