package com.provismet.CombatPlusCore.enchantment.effect.doubleEntity;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.effect.CPCEnchantmentEntityEffect;
import com.provismet.CombatPlusCore.interfaces.MeleeWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_9699;

/**
 * Triggers the attacker's on-kill effect against the attacker.
 */
public record WeaponPostKillEffect () implements CPCEnchantmentEntityEffect {
    public static final MapCodec<WeaponPostKillEffect> CODEC = MapCodec.unit(WeaponPostKillEffect::new);

    @Override
    public void apply (class_3218 world, int level, class_9699 context, class_1297 attacker, class_1297 target) {
        if (attacker instanceof class_1309 livingAttacker && target instanceof class_1309 livingTarget) {
            if (context.comp_2682().method_7909() instanceof MeleeWeapon meleeWeapon)
                meleeWeapon.postKill(context.comp_2682(), livingAttacker, livingTarget);
            else if (attacker.method_59958().method_7909() instanceof MeleeWeapon meleeWeapon)
                meleeWeapon.postKill(attacker.method_59958(), livingAttacker, livingTarget);
        }
    }

    @Override
    public MapCodec<? extends CPCEnchantmentEntityEffect> getCodec () {
        return CODEC;
    }
}
