package com.provismet.CombatPlusCore.enchantment.effect.singleEntity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;

/**
 * Applies velocity to the entity. The velocity is NOT normalised.
 * @param x The x component.
 * @param y The y component.
 * @param z The z component.
 * @param strength The strength of the velocity vector. All values are multiplied by strength.
 */
public record ApplyVelocityEffect (double x, double y, double z, class_9704 strength, boolean respectAttribute) implements class_9721 {
    public static final MapCodec<ApplyVelocityEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            Codec.DOUBLE.fieldOf("x").forGetter(ApplyVelocityEffect::x),
            Codec.DOUBLE.fieldOf("y").forGetter(ApplyVelocityEffect::y),
            Codec.DOUBLE.fieldOf("z").forGetter(ApplyVelocityEffect::z),
            class_9704.field_51690.fieldOf("strength").forGetter(ApplyVelocityEffect::strength),
            Codec.BOOL.fieldOf("respect_knockback_resistance").forGetter(ApplyVelocityEffect::respectAttribute)
        ).apply(instance, ApplyVelocityEffect::new)
    );

    @Override
    public void method_60220 (class_3218 world, int level, class_9699 context, class_1297 entity, class_243 pos) {
        class_243 velocity = new class_243(this.x, this.y, this.z);
        if (entity instanceof class_1309 living) {
            double strengthValue = this.strength.method_60188(level);
            if (this.respectAttribute) strengthValue *= 1 - living.method_45325(class_5134.field_23718);
            if (strengthValue <= 0) return;

            living.method_60491(velocity.method_1021(strengthValue));
            living.field_6037 = true;
        }
        else {
            entity.method_60491(velocity.method_1021(this.strength.method_60188(level)));
            entity.field_6037 = true;
        }
    }

    @Override
    public MapCodec<? extends class_9721> method_60219 () {
        return CODEC;
    }
}
