package com.provismet.CombatPlusCore.enchantment.effect.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.provismet.CombatPlusCore.CPCMain;
import com.provismet.CombatPlusCore.enchantment.effect.doubleEntity.CodeExecutionDoubleEntityEffect;
import com.provismet.CombatPlusCore.utility.CPCRegistries;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9699;
import net.minecraft.class_9721;

/**
 * Executes a registered lambda function against an entity.
 * @see CodeExecutionDoubleEntityEffect
 * @param function The id of the function.
 */
public record CodeExecutionSingleEntityEffect (class_2960 function) implements class_9721 {
    public static final MapCodec<CodeExecutionSingleEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_2960.field_25139.fieldOf("function").forGetter(CodeExecutionSingleEntityEffect::function)
        ).apply(instance, CodeExecutionSingleEntityEffect::new)
    );

    @Override
    public void method_60220 (class_3218 world, int level, class_9699 context, class_1297 entity, class_243 pos) {
        Lambda lambda = CPCRegistries.SINGLE_ENTITY_LAMBDA.method_63535(this.function);
        if (lambda == null) {
            CPCMain.LOGGER.warn("Enchantment attempted to execute unregistered lambda function: {}", this.function.toString());
            return;
        }
        lambda.execute(world, level, context, entity, pos);
    }

    @Override
    public MapCodec<? extends class_9721> method_60219 () {
        return CODEC;
    }

    @FunctionalInterface
    public interface Lambda {
        void execute (class_3218 world, int level, class_9699 context, class_1297 user, class_243 pos);
    }
}
