package com.provismet.CombatPlusCore.enchantment.effect.singleEntity;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;

/**
 * Applies frozen ticks to the target.
 * @param duration The number of seconds to apply frozen ticks for. The entity gains {@code duration * 20} ticks.
 */
public record FreezeEffect (class_9704 duration) implements class_9721 {
    public static final MapCodec<FreezeEffect> CODEC = RecordCodecBuilder.mapCodec(instance ->
        instance.group(
            class_9704.field_51690.fieldOf("duration").forGetter(effect -> effect.duration)
        ).apply(instance, FreezeEffect::new)
    );

    @Override
    public void method_60220 (class_3218 world, int level, class_9699 context, class_1297 entity, class_243 pos) {
        int ticks = Math.min(entity.method_32312() + (int)(this.duration.method_60188(level) * 20), entity.method_32315() + 100);
        entity.method_32317(ticks);
    }

    @Override
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }
}
