package com.provismet.CombatPlusCore.enchantment.loot.condition.doubleEntity;

import com.mojang.serialization.MapCodec;
import com.provismet.CombatPlusCore.enchantment.loot.condition.DoubleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.condition.SingleEntityCondition;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContext;
import com.provismet.CombatPlusCore.enchantment.loot.context.CPCLootContextParameters;
import com.provismet.CombatPlusCore.registries.DoubleEntityLootConditionTypes;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

/**
 * Applies a single condition to the target.
 */
public class ApplyToTargetCondition extends AbstractSingleWrapperCondition {
    public static final MapCodec<ApplyToTargetCondition> CODEC = ApplyToTargetCondition.createCodec(ApplyToTargetCondition::new);

    protected ApplyToTargetCondition (class_5341 condition) {
        super(condition);
    }

    @Override
    public class_5342 method_29325 () {
        return DoubleEntityLootConditionTypes.APPLY_TO_TARGET;
    }

    @Override
    public boolean test (class_47 lootContext) {
        class_47 targetContext = CPCLootContext.createSingleEntity(
            lootContext.method_299(),
            lootContext.method_65013(class_181.field_51805),
            lootContext.method_65013(CPCLootContextParameters.TARGET_ENTITY),
            null
        );
        return this.condition.test(targetContext);
    }

    public static DoubleEntityCondition.Builder builder (SingleEntityCondition.Builder combatCondition) {
        return () -> new ApplyToTargetCondition(combatCondition.build());
    }

    public static DoubleEntityCondition.Builder builder (SingleEntityCondition combatCondition) {
        return () -> new ApplyToTargetCondition(combatCondition);
    }

    public static DoubleEntityCondition.Builder builder (class_5341.class_210 condition) {
        return () -> new ApplyToTargetCondition(condition.build());
    }

    public static DoubleEntityCondition.Builder builder (class_5341 condition) {
        return () -> new ApplyToTargetCondition(condition);
    }
}
